/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.x509.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.sdf.SdfSymmetricCipher;
import com.xdja.pki.gmssl.crypto.sdf.SdfSymmetricKeyParameters;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2EncryptUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2KeyUtils;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdSymmetric;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.crmf.EncryptedValue;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMSSLCMPUtils {
    private static Logger logger = LoggerFactory.getLogger(GMSSLCMPUtils.class.getName());

    public static EncryptedValue generateEncryptedValueByBC(X509Certificate certificate) throws CertificateEncodingException, IOException, CryptoException, NoSuchPaddingException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, NoSuchProviderException, InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmIdentifier intendedAlg = null;
        AlgorithmIdentifier symmAlg = new AlgorithmIdentifier(GMObjectIdentifiers.sms4_cbc);
        byte[] key = new SecureRandom().generateSeed(16);
        byte[] encSymmKeyText = GMSSLCMPUtils.generateEncSymmKeyByBC((ECPublicKey)certificate.getPublicKey(), key);
        DERBitString encSymmKey = new DERBitString(encSymmKeyText);
        AlgorithmIdentifier keyAlg = new AlgorithmIdentifier(GMObjectIdentifiers.sm2encrypt_with_sm3);
        ASN1OctetString valueHint = null;
        byte[] plainText = certificate.getEncoded();
        byte[] encValueText = GMSSLCMPUtils.generateEncValueByBC(key, plainText);
        DERBitString encValue = new DERBitString(encValueText);
        return new EncryptedValue(intendedAlg, symmAlg, encSymmKey, keyAlg, valueHint, encValue);
    }

    public static byte[] generateEncSymmKeyByBC(ECPublicKey ecPublicKey, byte[] key) throws IOException, CryptoException {
        return GMSSLSM2EncryptUtils.encryptASN1ByBC((PublicKey)ecPublicKey, key);
    }

    public static byte[] generateEncValueByBC(byte[] keyBytes, byte[] plainText) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException {
        Cipher cipher = Cipher.getInstance("SM4/CBC/PKCS7Padding", "BC");
        SecretKeySpec key = new SecretKeySpec(keyBytes, "SM4");
        byte[] iv = new byte[16];
        cipher.init(1, (Key)key, new IvParameterSpec(iv));
        byte[] encrypt = cipher.doFinal(plainText);
        return encrypt;
    }

    public static EncryptedValue generateEncryptedValueByYunhsm(X509Certificate certificate) throws SdfSDKException, CertificateEncodingException {
        return GMSSLCMPUtils.generateEncryptedValueBySdf(SdfCryptoType.YUNHSM, certificate);
    }

    public static EncryptedValue generateEncryptedValueByPcie(X509Certificate certificate) throws SdfSDKException, CertificateEncodingException {
        return GMSSLCMPUtils.generateEncryptedValueBySdf(SdfCryptoType.PCIE, certificate);
    }

    public static EncryptedValue generateEncryptedValueBySdf(SdfCryptoType sdfCryptoType, X509Certificate certificate) throws SdfSDKException, CertificateEncodingException {
        AlgorithmIdentifier intendedAlg = null;
        AlgorithmIdentifier symmAlg = new AlgorithmIdentifier(GMObjectIdentifiers.sms4_cbc);
        byte[] plainText = certificate.getEncoded();
        SdfSymmetricCipher sdfSymmetric = new SdfSymmetricCipher(sdfCryptoType);
        SdfSymmetricKeyParameters param = new SdfSymmetricKeyParameters(SdfSymmetricKeyParameters.PaddingType.PKCS7Padding, SdfAlgIdSymmetric.SGD_SM4_CBC, (ECPublicKey)certificate.getPublicKey());
        sdfSymmetric.init(true, param);
        byte[] encValueText = sdfSymmetric.doFinal(plainText);
        sdfSymmetric.release();
        DERBitString encSymmKey = new DERBitString(sdfSymmetric.getKey());
        AlgorithmIdentifier keyAlg = new AlgorithmIdentifier(GMObjectIdentifiers.sm2encrypt_with_sm3);
        ASN1OctetString valueHint = null;
        DERBitString encValue = new DERBitString(encValueText);
        return new EncryptedValue(intendedAlg, symmAlg, encSymmKey, keyAlg, valueHint, encValue);
    }

    public static X509Certificate decodeEncryptedValueByBC(PrivateKey privateKey, byte[] encryptedValueText) throws CertificateException, NoSuchPaddingException, BadPaddingException, NoSuchAlgorithmException, IOException, InvalidCipherTextException, IllegalBlockSizeException, NoSuchProviderException, InvalidKeyException, InvalidAlgorithmParameterException {
        EncryptedValue value = EncryptedValue.getInstance(encryptedValueText);
        EncryptedValue encryptedValue = EncryptedValue.getInstance(encryptedValueText);
        AlgorithmIdentifier symmAlg = encryptedValue.getSymmAlg();
        if (!symmAlg.getAlgorithm().getId().equals(GMObjectIdentifiers.sms4_cbc.getId())) {
            throw new IOException("unSupport algorithm identifier " + symmAlg.getAlgorithm());
        }
        AlgorithmIdentifier keyAlg = encryptedValue.getKeyAlg();
        if (!keyAlg.getAlgorithm().getId().equals(GMObjectIdentifiers.sm2encrypt_with_sm3.getId())) {
            throw new IOException("unSupport algorithm identifier " + keyAlg.getAlgorithm());
        }
        byte[] encSymmKeyText = encryptedValue.getEncSymmKey().getOctets();
        byte[] cipherText = encryptedValue.getEncValue().getOctets();
        byte[] plainText = GMSSLCMPUtils.decodeEncValueByBC(privateKey, encSymmKeyText, cipherText);
        return GMSSLX509Utils.readCertificateFromCerByte(plainText);
    }

    public static byte[] decodeEncValueByBC(PrivateKey privateKey, byte[] encSymmKeyText, byte[] cipherText) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, IOException, InvalidCipherTextException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException {
        Cipher cipher = Cipher.getInstance("SM4/CBC/PKCS7Padding", "BC");
        byte[] keyBytes = GMSSLSM2EncryptUtils.decryptASN1ByBC(privateKey, encSymmKeyText);
        SecretKeySpec key = new SecretKeySpec(keyBytes, "SM4");
        byte[] iv = new byte[16];
        cipher.init(2, (Key)key, new IvParameterSpec(iv));
        return cipher.doFinal(cipherText);
    }

    public static X509Certificate decodeEncryptedValueByYunhsm(int privateKeyIndex, String privateKeyPassword, byte[] encryptedValueText) throws SdfSDKException, CertificateException, NoSuchProviderException, IOException {
        return GMSSLCMPUtils.decodeEncryptedValue(SdfCryptoType.YUNHSM, privateKeyIndex, privateKeyPassword, encryptedValueText);
    }

    public static X509Certificate decodeEncryptedValueByPcie(int privateKeyIndex, String privateKeyPassword, byte[] encryptedValueText) throws SdfSDKException, CertificateException, NoSuchProviderException {
        return GMSSLCMPUtils.decodeEncryptedValue(SdfCryptoType.PCIE, privateKeyIndex, privateKeyPassword, encryptedValueText);
    }

    public static X509Certificate decodeEncryptedValue(SdfCryptoType sdfCryptoType, int privateKeyIndex, String privateKeyPassword, byte[] encryptedValueText) throws SdfSDKException, CertificateException, NoSuchProviderException {
        EncryptedValue encryptedValue = EncryptedValue.getInstance(encryptedValueText);
        AlgorithmIdentifier symmAlg = encryptedValue.getSymmAlg();
        if (!symmAlg.getAlgorithm().getId().equals(GMObjectIdentifiers.sms4_cbc.getId())) {
            throw new SdfSDKException("unSupport algorithm identifier " + symmAlg.getAlgorithm());
        }
        AlgorithmIdentifier keyAlg = encryptedValue.getKeyAlg();
        if (!keyAlg.getAlgorithm().getId().equals(GMObjectIdentifiers.sm2encrypt_with_sm3.getId())) {
            throw new SdfSDKException("unSupport algorithm identifier " + keyAlg.getAlgorithm());
        }
        byte[] encSymmKeyText = encryptedValue.getEncSymmKey().getOctets();
        byte[] cipherText = encryptedValue.getEncValue().getOctets();
        SdfPrivateKey sdfPrivateKey = GMSSLSM2KeyUtils.genSdfPrivateKey(privateKeyIndex, privateKeyPassword);
        byte[] plainText = GMSSLCMPUtils.decodeEncValueBySdf(sdfCryptoType, sdfPrivateKey, encSymmKeyText, cipherText);
        return GMSSLX509Utils.readCertificateFromCerByte(plainText);
    }

    public static byte[] decodeEncValueBySdf(SdfCryptoType sdfCryptoType, SdfPrivateKey sdfPrivateKey, byte[] encSymmKeyText, byte[] cipherText) throws SdfSDKException {
        SdfSymmetricCipher sdfSymmetric = new SdfSymmetricCipher(sdfCryptoType);
        SdfSymmetricKeyParameters param = new SdfSymmetricKeyParameters(SdfSymmetricKeyParameters.PaddingType.PKCS7Padding, SdfAlgIdSymmetric.SGD_SM4_CBC, sdfPrivateKey, encSymmKeyText);
        sdfSymmetric.init(false, param);
        byte[] plainText = sdfSymmetric.doFinal(cipherText);
        sdfSymmetric.release();
        return plainText;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }
}

