/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.x509.utils;

import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2KeyUtils;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancContentSigner;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancContentVerifierProvider;
import com.xdja.pki.gmssl.operator.utils.GMSSLContentSignerUtils;
import com.xdja.pki.gmssl.operator.utils.GMSSLContentVerifierProviderUtils;
import com.xdja.pki.gmssl.operator.utils.GMSSLXkfContentSigner;
import com.xdja.pki.gmssl.operator.utils.GMSSLXkfContentVerifierProvider;
import com.xdja.pki.gmssl.x509.utils.bean.CRLEntry;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLCryptoType;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.CRLNumber;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.CertException;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509v2CRLBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CRLConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.OperatorCreationException;

public class GMSSLCRLUtils {
    public static X509CRL generateCRL(X509Certificate issueCert, PrivateKey issuerKey, String algorithm, Date thisUpdate, Date nextUpdate, List<Extension> extensions, List<CRLEntry> revoked, boolean isWithParam) throws IOException, OperatorCreationException, CRLException {
        return GMSSLCRLUtils.generateCRL(issueCert, issuerKey, algorithm, null, thisUpdate, nextUpdate, extensions, revoked, isWithParam);
    }

    public static X509CRL generateCRL(X509Certificate issueCert, PrivateKey issuerKey, String algorithm, BigInteger crlNumber, Date thisUpdate, Date nextUpdate, List<Extension> extensions, List<CRLEntry> revoked, boolean isWithParam) throws IOException, OperatorCreationException, CRLException {
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case PCI_E: {
                SdfPrivateKey pciePrivateKey = (SdfPrivateKey)issuerKey;
                return GMSSLCRLUtils.generateCRLByPCIE(issueCert, pciePrivateKey.getIndex(), pciePrivateKey.getStringPassword(), algorithm, crlNumber, thisUpdate, thisUpdate, extensions, revoked, isWithParam);
            }
            case XDJA_HSM: {
                SdfPrivateKey hsmPrivateKey = (SdfPrivateKey)issuerKey;
                return GMSSLCRLUtils.generateCRLByYunhsm(issueCert, hsmPrivateKey.getIndex(), hsmPrivateKey.getStringPassword(), algorithm, crlNumber, thisUpdate, thisUpdate, extensions, revoked, isWithParam);
            }
            case MINI_PCI_E: {
                return GMSSLCRLUtils.generateCRLByMiniPcie(issueCert, issuerKey, algorithm, crlNumber, thisUpdate, nextUpdate, extensions, revoked, isWithParam);
            }
            case SANC_HSM: {
                return GMSSLCRLUtils.generateCRLBySanc(issueCert, issuerKey, algorithm, crlNumber, thisUpdate, nextUpdate, extensions, revoked, isWithParam);
            }
        }
        ContentSigner contentSigner = GMSSLContentSignerUtils.generateContentSignerByBC(algorithm, issuerKey);
        return GMSSLCRLUtils.generateCRL(issueCert, contentSigner, crlNumber, thisUpdate, nextUpdate, extensions, revoked);
    }

    public static boolean verifyCRL(PublicKey publicKey, X509CRL crl) throws IOException, CRLException, CertException, OperatorCreationException {
        switch (GMSSLPkiCryptoInit.getCryptoType()) {
            case PCI_E: {
                ContentVerifierProvider pcieContentVerifierProvider = GMSSLContentVerifierProviderUtils.generateContentVerifierByPcie(publicKey);
                return GMSSLCRLUtils.verifyCRL(pcieContentVerifierProvider, crl.getEncoded());
            }
            case XDJA_HSM: {
                ContentVerifierProvider hsmContentVerifierProvider = GMSSLContentVerifierProviderUtils.generateContentVerifierByYunHsm(publicKey);
                return GMSSLCRLUtils.verifyCRL(hsmContentVerifierProvider, crl.getEncoded());
            }
            case MINI_PCI_E: {
                return GMSSLCRLUtils.verifyCRLByMiniPcie(publicKey, crl);
            }
            case SANC_HSM: {
                return GMSSLCRLUtils.verifyCRLBySanc(publicKey, crl);
            }
        }
        ContentVerifierProvider contentVerifierProvider = GMSSLContentVerifierProviderUtils.generateContentVerifierByBC(publicKey);
        return GMSSLCRLUtils.verifyCRL(contentVerifierProvider, crl.getEncoded());
    }

    public static X509CRL generateCRLBySanc(X509Certificate issueCert, PrivateKey issuerKey, String algorithm, BigInteger crlNumber, Date thisUpdate, Date nextUpdate, List<Extension> extensions, List<CRLEntry> revoked, boolean isWithParam) throws IOException, CRLException {
        GMSSLSancContentSigner contentSigner = new GMSSLSancContentSigner(algorithm, issuerKey, isWithParam);
        return GMSSLCRLUtils.generateCRL(issueCert, contentSigner, crlNumber, thisUpdate, nextUpdate, extensions, revoked);
    }

    public static boolean verifyCRLBySanc(PublicKey publicKey, X509CRL crl) throws IOException, CRLException, CertException {
        GMSSLSancContentVerifierProvider contentVerifierProvider = new GMSSLSancContentVerifierProvider(publicKey);
        return GMSSLCRLUtils.verifyCRL(contentVerifierProvider, crl.getEncoded());
    }

    public static X509CRL generateCRLByMiniPcie(X509Certificate issueCert, PrivateKey issuerKey, String algorithm, BigInteger crlNumber, Date thisUpdate, Date nextUpdate, List<Extension> extensions, List<CRLEntry> revoked, boolean isWithParam) throws IOException, CRLException {
        GMSSLXkfContentSigner contentSigner = new GMSSLXkfContentSigner(algorithm, issuerKey, isWithParam);
        return GMSSLCRLUtils.generateCRL(issueCert, contentSigner, crlNumber, thisUpdate, nextUpdate, extensions, revoked);
    }

    public static boolean verifyCRLByMiniPcie(PublicKey publicKey, X509CRL crl) throws IOException, CRLException, CertException {
        GMSSLXkfContentVerifierProvider contentVerifierProvider = new GMSSLXkfContentVerifierProvider(publicKey);
        return GMSSLCRLUtils.verifyCRL(contentVerifierProvider, crl.getEncoded());
    }

    public static X509CRL generateCRLByBC(X509Certificate issueCert, PrivateKey issuerKey, String algorithm, BigInteger crlNumber, Date thisUpdate, Date nextUpdate, List<Extension> extensions, List<CRLEntry> revoked) throws IOException, OperatorCreationException, CRLException {
        ContentSigner contentSigner = GMSSLContentSignerUtils.generateContentSignerByBC(algorithm, issuerKey);
        return GMSSLCRLUtils.generateCRL(issueCert, contentSigner, crlNumber, thisUpdate, nextUpdate, extensions, revoked);
    }

    public static X509CRL generateCRLByBC(X509Certificate issueCert, PrivateKey issuerKey, String algorithm, BigInteger crlNumber, Date thisUpdate, Date nextUpdate, List<Extension> extensions, List<CRLEntry> revoked, boolean isWithParam) throws IOException, OperatorCreationException, CRLException {
        ContentSigner contentSigner = GMSSLContentSignerUtils.generateContentSignerByBC(algorithm, issuerKey, isWithParam);
        return GMSSLCRLUtils.generateCRL(issueCert, contentSigner, crlNumber, thisUpdate, nextUpdate, extensions, revoked);
    }

    public static X509CRL generateCRLByYunhsm(X509Certificate issueCert, int issuerKeyIndex, String issuerKeyPassword, String algorithm, BigInteger crlNumber, Date thisUpdate, Date nextUpdate, List<Extension> extensions, List<CRLEntry> revoked) throws IOException, OperatorCreationException, CRLException {
        SdfPrivateKey sdfPrivateKey = GMSSLSM2KeyUtils.genSdfPrivateKey(issuerKeyIndex, issuerKeyPassword);
        if (GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM) {
            return GMSSLCRLUtils.generateCRL(issueCert, sdfPrivateKey, algorithm, crlNumber, thisUpdate, nextUpdate, extensions, revoked, false);
        }
        ContentSigner contentSigner = GMSSLContentSignerUtils.generateContentSignerByYunhsm(algorithm, sdfPrivateKey);
        return GMSSLCRLUtils.generateCRL(issueCert, contentSigner, crlNumber, thisUpdate, nextUpdate, extensions, revoked);
    }

    public static X509CRL generateCRLByYunhsm(X509Certificate issueCert, int issuerKeyIndex, String issuerKeyPassword, String algorithm, BigInteger crlNumber, Date thisUpdate, Date nextUpdate, List<Extension> extensions, List<CRLEntry> revoked, boolean isWithParam) throws IOException, OperatorCreationException, CRLException {
        SdfPrivateKey sdfPrivateKey = GMSSLSM2KeyUtils.genSdfPrivateKey(issuerKeyIndex, issuerKeyPassword);
        if (GMSSLPkiCryptoInit.getCryptoType() == GMSSLCryptoType.SANC_HSM) {
            return GMSSLCRLUtils.generateCRL(issueCert, sdfPrivateKey, algorithm, crlNumber, thisUpdate, nextUpdate, extensions, revoked, isWithParam);
        }
        ContentSigner contentSigner = GMSSLContentSignerUtils.generateContentSignerByYunhsm(algorithm, sdfPrivateKey, isWithParam);
        return GMSSLCRLUtils.generateCRL(issueCert, contentSigner, crlNumber, thisUpdate, nextUpdate, extensions, revoked);
    }

    public static X509CRL generateCRLByPCIE(X509Certificate issueCert, int issuerKeyIndex, String issuerKeyPassword, String algorithm, BigInteger crlNumber, Date thisUpdate, Date nextUpdate, List<Extension> extensions, List<CRLEntry> revoked) throws IOException, OperatorCreationException, CRLException {
        SdfPrivateKey sdfPrivateKey = GMSSLSM2KeyUtils.genSdfPrivateKey(issuerKeyIndex, issuerKeyPassword);
        ContentSigner contentSigner = GMSSLContentSignerUtils.generateContentSignerByPcie(algorithm, sdfPrivateKey);
        return GMSSLCRLUtils.generateCRL(issueCert, contentSigner, crlNumber, thisUpdate, nextUpdate, extensions, revoked);
    }

    public static X509CRL generateCRLByPCIE(X509Certificate issueCert, int issuerKeyIndex, String issuerKeyPassword, String algorithm, BigInteger crlNumber, Date thisUpdate, Date nextUpdate, List<Extension> extensions, List<CRLEntry> revoked, boolean isWithParam) throws IOException, OperatorCreationException, CRLException {
        SdfPrivateKey sdfPrivateKey = GMSSLSM2KeyUtils.genSdfPrivateKey(issuerKeyIndex, issuerKeyPassword);
        ContentSigner contentSigner = GMSSLContentSignerUtils.generateContentSignerByPcie(algorithm, sdfPrivateKey, isWithParam);
        return GMSSLCRLUtils.generateCRL(issueCert, contentSigner, crlNumber, thisUpdate, nextUpdate, extensions, revoked);
    }

    public static X509CRL generateCRL(X509Certificate issueCert, ContentSigner contentSigner, BigInteger crlNumber, Date thisUpdate, Date nextUpdate, List<Extension> extensions, List<CRLEntry> revoked) throws IOException, CRLException {
        X509v2CRLBuilder builder = new X509v2CRLBuilder(new X500Name(issueCert.getSubjectDN().getName()), thisUpdate);
        if (null != crlNumber) {
            builder.addExtension(Extension.cRLNumber, false, new CRLNumber(crlNumber));
        }
        builder.setNextUpdate(nextUpdate);
        if (extensions != null) {
            for (Extension extension : extensions) {
                builder.addExtension(extension);
            }
        }
        if (revoked != null) {
            for (CRLEntry entry : revoked) {
                builder.addCRLEntry(new BigInteger(entry.getUserCertificateSerial(), 16), entry.getRevocationDate(), entry.getReason());
            }
        }
        X509CRLHolder crlHolder = builder.build(contentSigner);
        return new JcaX509CRLConverter().setProvider("BC").getCRL(crlHolder);
    }

    public static X509CRL decodeCRLByBC(PublicKey publicKey, byte[] crlEncode) throws OperatorCreationException, CRLException, IOException, CertException {
        ContentVerifierProvider contentVerifierProvider = GMSSLContentVerifierProviderUtils.generateContentVerifierByBC(publicKey);
        return GMSSLCRLUtils.decodeCRL(contentVerifierProvider, crlEncode);
    }

    public static X509CRL decodeCRLByYunhsm(PublicKey publicKey, byte[] crlEncode) throws CRLException, IOException, CertException {
        return GMSSLCRLUtils.decodeCRLBySdf(SdfCryptoType.YUNHSM, publicKey, crlEncode);
    }

    public static X509CRL decodeCRLByPcie(PublicKey publicKey, byte[] crlEncode) throws CRLException, IOException, CertException {
        return GMSSLCRLUtils.decodeCRLBySdf(SdfCryptoType.PCIE, publicKey, crlEncode);
    }

    public static X509CRL decodeCRLBySdf(SdfCryptoType sdfCryptoType, PublicKey publicKey, byte[] crlEncode) throws CRLException, IOException, CertException {
        ContentVerifierProvider contentVerifierProvider = GMSSLContentVerifierProviderUtils.generateContentVerifierBySdf(sdfCryptoType, publicKey);
        return GMSSLCRLUtils.decodeCRL(contentVerifierProvider, crlEncode);
    }

    public static X509CRL decodeCRL(ContentVerifierProvider contentVerifierProvider, byte[] crlEncode) throws IOException, CertException, CRLException {
        X509CRLHolder holder = new X509CRLHolder(crlEncode);
        holder.isSignatureValid(contentVerifierProvider);
        return new JcaX509CRLConverter().setProvider("BC").getCRL(holder);
    }

    private static boolean verifyCRL(ContentVerifierProvider contentVerifierProvider, byte[] crlEncode) throws IOException, CertException {
        X509CRLHolder holder = new X509CRLHolder(crlEncode);
        return holder.isSignatureValid(contentVerifierProvider);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }
}

