/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs;

import com.xdja.svs.alg.EncAlg;
import com.xdja.svs.alg.HashAlg;
import com.xdja.svs.alg.SignAlg;
import com.xdja.svs.config.ApplicationConfig;
import com.xdja.svs.execption.SOR_ParameterNotSupportedException;
import com.xdja.svs.protocol.response.AppContext;
import com.xdja.svs.socket.SocketFactory;
import com.xdja.svs.utils.CertUtils;
import java.net.Socket;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.x500.X500Name;

public class Session {
    private ApplicationConfig applicationConfig;
    private Socket socketFd;
    private AppContext appContext;
    private SignAlg signAlg;
    private EncAlg encAlg;
    private SocketFactory socketFactory;
    private int verifyType = 1;
    boolean isHashValue;
    int unknownAlg = 0;
    private HashAlg hashAlg;

    public Session(ApplicationConfig applicationConfig, SocketFactory factory) {
        this.applicationConfig = applicationConfig;
        this.socketFactory = factory;
        this.socketFd = factory.getSocket();
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public Socket getSocketFd() {
        return this.socketFd;
    }

    public String getServerIP() {
        return this.applicationConfig.getServerIp();
    }

    public int getServerPort() {
        return this.applicationConfig.getServerPort();
    }

    public int getTimeOut() {
        return this.applicationConfig.getTimeOut();
    }

    public int getPrivateKeyIndex() {
        return this.appContext.getKeyIndex().getValue().intValue();
    }

    public String getPrivateKeyPwd() {
        return this.applicationConfig.getPassWd();
    }

    public int getVerifyLevel() {
        return this.applicationConfig.getVerifyLevel();
    }

    public boolean isOcsp() {
        return this.applicationConfig.isOcspStatus();
    }

    public int getXmlType() {
        return this.applicationConfig.getXmlType();
    }

    public boolean isCertReq() {
        return this.applicationConfig.getTsaCertReq() == 0;
    }

    public String getAppName() {
        return this.applicationConfig.getAppName();
    }

    public int getPrivateKeyPwdLength() {
        return this.getPrivateKeyPwd().length();
    }

    public void setSignAlg(SignAlg signAlg) {
        this.signAlg = signAlg;
    }

    public long getSignAlg() {
        if (this.signAlg == null) {
            return this.unknownAlg;
        }
        return this.signAlg.getAlgId();
    }

    public void setEncAlg(EncAlg encAlg) {
        this.encAlg = encAlg;
    }

    public long getEncAlg() {
        if (this.encAlg == null) {
            return this.unknownAlg;
        }
        return this.encAlg.getEncAlgId();
    }

    public String getSignID() {
        return "1234567812345678";
    }

    public X500Name getSignIssuer() throws SOR_ParameterNotSupportedException {
        if (null == this.appContext) {
            throw new SOR_ParameterNotSupportedException(" appContext is null,can not get Sign Issuer");
        }
        return this.appContext.getSignIssuer();
    }

    public ASN1Integer getSignSerial() throws SOR_ParameterNotSupportedException {
        if (null == this.appContext) {
            throw new SOR_ParameterNotSupportedException(" appContext is null,can not get Sign Serial");
        }
        return this.appContext.getSignSerial();
    }

    public X500Name getEncIssuer() throws SOR_ParameterNotSupportedException {
        if (null == this.appContext) {
            throw new SOR_ParameterNotSupportedException(" appContext is null,can not get Enc Issuer");
        }
        return this.appContext.getEncIssuer();
    }

    public ASN1Integer getEncSerial() throws SOR_ParameterNotSupportedException {
        if (null == this.appContext) {
            throw new SOR_ParameterNotSupportedException(" appContext is null,can not get Enc Cert SN");
        }
        return this.appContext.getEncSerial();
    }

    public X509Certificate getSignCert() throws SOR_ParameterNotSupportedException {
        if (null == this.appContext) {
            throw new SOR_ParameterNotSupportedException(" appContext is null,can not get Sign Cert");
        }
        return this.appContext.getSignCert();
    }

    public X509Certificate getEncCert() throws SOR_ParameterNotSupportedException {
        if (null == this.appContext) {
            throw new SOR_ParameterNotSupportedException(" appContext is null,can not get Enc Cert");
        }
        return this.appContext.getEncCert();
    }

    public void setAppContext(AppContext appContext) {
        this.appContext = appContext;
    }

    public int getVerifyType() {
        return this.verifyType;
    }

    public void setVerifyType(int verifyType) {
        this.verifyType = verifyType;
    }

    public boolean isHashValue() {
        return this.isHashValue;
    }

    public void setHashValue(boolean hashValue) {
        this.isHashValue = hashValue;
    }

    public int getKeyBits() throws SOR_ParameterNotSupportedException {
        return CertUtils.getPublicKeyLength(this.getSignCert());
    }

    public void setHashAlg(HashAlg hashAlg) {
        this.hashAlg = hashAlg;
    }

    public long getHashAlg() {
        if (this.hashAlg == null) {
            return this.unknownAlg;
        }
        return this.hashAlg.getAlgId();
    }
}

