/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.alg;

import com.xdja.svs.gmt.GMOid;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public enum EncAlg {
    SM1_ECB(257L){

        @Override
        public AlgorithmIdentifier createOid() {
            return new AlgorithmIdentifier(GMOid.sm1_ecb);
        }
    }
    ,
    SM1_CBC(258L){

        @Override
        public AlgorithmIdentifier createOid() {
            return new AlgorithmIdentifier(GMOid.sm1_cbc);
        }
    }
    ,
    SM1_OFB(264L){

        @Override
        public AlgorithmIdentifier createOid() {
            return new AlgorithmIdentifier(GMOid.sm1_ofb128);
        }
    }
    ,
    SM1_CFB(260L){

        @Override
        public AlgorithmIdentifier createOid() {
            return new AlgorithmIdentifier(GMOid.sm1_cfb128);
        }
    }
    ,
    SM4_ECB(1025L){

        @Override
        public AlgorithmIdentifier createOid() {
            return new AlgorithmIdentifier(GMOid.sms4_ecb);
        }
    }
    ,
    SM4_CBC(1026L){

        @Override
        public AlgorithmIdentifier createOid() {
            return new AlgorithmIdentifier(GMOid.sms4_cbc);
        }
    }
    ,
    SM4_OFB(1032L){

        @Override
        public AlgorithmIdentifier createOid() {
            return new AlgorithmIdentifier(GMOid.sms4_ofb128);
        }
    }
    ,
    SM4_CFB(1028L){

        @Override
        public AlgorithmIdentifier createOid() {
            return new AlgorithmIdentifier(GMOid.sms4_cfb128);
        }
    }
    ,
    AES_ECB(4353L){

        @Override
        public AlgorithmIdentifier createOid() {
            return new AlgorithmIdentifier(new ASN1ObjectIdentifier("2.16.840.1.101.3.4.1.1"));
        }
    };

    long encAlgId;

    private EncAlg(long encAlgId) {
        this.encAlgId = encAlgId;
    }

    public static EncAlg find(long algId) {
        for (EncAlg encAlg : EncAlg.values()) {
            if (encAlg.encAlgId != algId) continue;
            return encAlg;
        }
        return null;
    }

    public static boolean matchEncAlg(long algId) {
        return EncAlg.find(algId) != null;
    }

    public long getEncAlgId() {
        return this.encAlgId;
    }

    public static boolean wrapIv(long algId) {
        return algId != EncAlg.SM1_ECB.encAlgId && algId != EncAlg.SM4_ECB.encAlgId && EncAlg.AES_ECB.encAlgId != algId;
    }

    public abstract AlgorithmIdentifier createOid();
}

