/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.alg;

public enum HashAlg {
    SM3(1L),
    SHA1(2L),
    SHA256(4L),
    SHA224(8L),
    SHA384(11L),
    SHA512(12L),
    MD5(14L);

    long algId;

    private HashAlg(long algId) {
        this.algId = algId;
    }

    public long getAlgId() {
        return this.algId;
    }

    public static HashAlg find(long algId) {
        for (HashAlg hashAlg : HashAlg.values()) {
            if (hashAlg.getAlgId() != algId) continue;
            return hashAlg;
        }
        return null;
    }

    public static boolean matchedHashAlg(long algId) {
        return HashAlg.find(algId) != null;
    }
}

