/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.alg;

public enum SignAlg {
    SM3_RSA(65537L),
    SHA1_RSA(65538L),
    SHA256_RSA(65540L),
    SM3_SM2(131585L),
    SHA1_ECDSA(262146L),
    SHA256_ECDSA(262148L);

    long algId;

    private SignAlg(long algId) {
        this.algId = algId;
    }

    public long getAlgId() {
        return this.algId;
    }

    public static boolean matchRSAAlg(long algId) {
        return algId == SignAlg.SM3_RSA.algId || algId == SignAlg.SHA1_RSA.algId || algId == SignAlg.SHA256_RSA.algId;
    }

    public static boolean matchSm2Alg(long algId) {
        return algId == SignAlg.SM3_SM2.algId;
    }

    public static boolean matchSignAlg(long algId) {
        return SignAlg.find(algId) != null;
    }

    public static SignAlg find(long algId) {
        for (SignAlg signAlg : SignAlg.values()) {
            if (signAlg.algId != algId) continue;
            return signAlg;
        }
        return null;
    }
}

