/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.api;

import com.xdja.svs.Session;
import com.xdja.svs.api.BaseExternalApi;
import com.xdja.svs.execption.SOR_ParameterNotSupportedException;
import com.xdja.svs.execption.ServiceException;
import com.xdja.svs.protocol.signdata.request.SignDataFinalRequest;
import com.xdja.svs.protocol.signdata.request.SignDataInitRequest;
import com.xdja.svs.protocol.signdata.request.SignDataUpdateRequest;
import com.xdja.svs.protocol.signdata.request.SingleSignDataRequest;
import com.xdja.svs.protocol.signdata.response.SignDataFinalResponse;
import com.xdja.svs.protocol.signdata.response.SignDataInitResponse;
import com.xdja.svs.protocol.signdata.response.SignDataUpdateResponse;
import com.xdja.svs.protocol.signdata.response.SingleSignDataResponse;
import com.xdja.svs.utils.ApiUtils;
import org.bouncycastle.asn1.ASN1Sequence;

public abstract class BaseSignDataApi
extends BaseExternalApi<byte[], String> {
    protected void signedDataInit(Session session, byte[] inData) throws Exception {
        if (!ApiUtils.checkPubKeyAlg(session.getSignAlg(), session.getSignCert())) {
            throw new SOR_ParameterNotSupportedException("SOF_signData: pubkey can not match sign alg");
        }
        ASN1Sequence sequence = session.getSocketFactory().processing(session.getSocketFd(), new SignDataInitRequest(session, inData));
        if (sequence == null) {
            throw new ServiceException("SOF_signData : init--- response is null");
        }
        SignDataInitResponse signDataInitResponse = new SignDataInitResponse(sequence.getObjectAt(2));
        if (signDataInitResponse == null || !signDataInitResponse.isSuccess()) {
            throw new ServiceException("SOF_signData : init--- service internal error");
        }
    }

    protected void signedDataUpdate(Session session, byte[] inData, byte[] hash) throws Exception {
        ASN1Sequence sequence = session.getSocketFactory().processing(session.getSocketFd(), new SignDataUpdateRequest(session.getSignAlg(), hash, inData));
        if (sequence == null) {
            throw new ServiceException("SOF_signData : update--- response is null");
        }
        SignDataUpdateResponse signDataUpdateResponse = new SignDataUpdateResponse(sequence.getObjectAt(2));
        if (signDataUpdateResponse == null || !signDataUpdateResponse.isSuccess()) {
            throw new ServiceException("SOF_signData : update--- service internal error");
        }
    }

    protected SignDataFinalResponse signedDataFinal(Session session, byte[] hash) throws Exception {
        ASN1Sequence sequence = session.getSocketFactory().processing(session.getSocketFd(), new SignDataFinalRequest(session, hash));
        if (sequence == null) {
            throw new ServiceException("SOF_signData : final--- response is null");
        }
        return new SignDataFinalResponse(sequence.getObjectAt(2));
    }

    protected byte[] singleSignedData(Session session, byte[] originData) throws Exception {
        ASN1Sequence sequence = session.getSocketFactory().processing(session.getSocketFd(), new SingleSignDataRequest(session, originData));
        if (sequence == null) {
            throw new ServiceException("singleSignedData : response is null");
        }
        SingleSignDataResponse singleSignDataResponse = new SingleSignDataResponse(sequence.getObjectAt(2));
        if (singleSignDataResponse.isSuccess()) {
            return singleSignDataResponse.getSignature().getOctets();
        }
        throw new ServiceException("singleSignedData : service internal error");
    }
}

