/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.api.certinfo;

import com.xdja.svs.ErrorBundle;
import com.xdja.svs.Session;
import com.xdja.svs.api.BaseExternalApi;
import com.xdja.svs.api.certinfo.CertInfoType;
import com.xdja.svs.execption.SOR_ParameterNotSupportedException;
import com.xdja.svs.execption.ServiceException;
import com.xdja.svs.protocol.certinfo.ParseCertRequest;
import com.xdja.svs.protocol.certinfo.ParseCertResponse;
import com.xdja.svs.utils.Base64Utils;
import com.xdja.svs.utils.EmptyUtils;
import org.bouncycastle.asn1.ASN1Sequence;

public class ApiGetCertInfo
extends BaseExternalApi<Void, String> {
    Session session;
    int certInfoType;
    byte[] contentBytes;

    public ApiGetCertInfo(Session session, String certContent, int certInfoType) throws SOR_ParameterNotSupportedException {
        this.session = session;
        this.certInfoType = certInfoType;
        if (EmptyUtils.isEmpty(certContent)) {
            throw new SOR_ParameterNotSupportedException("SOF_getCertInfo:certContent's value is null");
        }
        this.checkBase64(certContent);
        this.contentBytes = Base64Utils.decode(certContent);
        if (!CertInfoType.isSupport(certInfoType)) {
            throw new SOR_ParameterNotSupportedException("SOF_getCertInfo:certInfoType's value is not support");
        }
    }

    public String execute(Void ... params) throws Exception {
        ASN1Sequence sequence = this.session.getSocketFactory().processing(this.session.getSocketFd(), new ParseCertRequest(this.certInfoType, this.contentBytes));
        if (sequence == null) {
            throw new ServiceException("SOF_getCertInfo : response is null");
        }
        ParseCertResponse parseCertResponse = new ParseCertResponse(sequence.getObjectAt(2));
        if (parseCertResponse == null) {
            throw new ServiceException("SOF_getCertInfo : service internal error");
        }
        if (!parseCertResponse.isSuccess()) {
            ErrorBundle.throwApiException(parseCertResponse.getRespValue().getValue().intValue());
        }
        byte[] encoded = parseCertResponse.getData().getOctets();
        CertInfoType certInfo = CertInfoType.matchType(this.certInfoType);
        return certInfo.parseInfo(encoded);
    }
}

