/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.api.certinfo;

import com.xdja.svs.api.BaseExternalApi;
import com.xdja.svs.execption.SOR_CertEncodeException;
import com.xdja.svs.execption.SOR_ParameterNotSupportedException;
import com.xdja.svs.utils.Base64Utils;
import com.xdja.svs.utils.CertUtils;
import java.security.cert.X509Certificate;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.Attribute;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectDirectoryAttributes;
import org.bouncycastle.asn1.x509.TBSCertificate;
import sun.security.pkcs11.wrapper.Functions;
import sun.security.x509.AuthorityInfoAccessExtension;
import sun.security.x509.AuthorityKeyIdentifierExtension;
import sun.security.x509.BasicConstraintsExtension;
import sun.security.x509.CRLDistributionPointsExtension;
import sun.security.x509.CRLNumberExtension;
import sun.security.x509.CRLReasonCodeExtension;
import sun.security.x509.CertificateIssuerExtension;
import sun.security.x509.CertificatePoliciesExtension;
import sun.security.x509.DeltaCRLIndicatorExtension;
import sun.security.x509.ExtendedKeyUsageExtension;
import sun.security.x509.FreshestCRLExtension;
import sun.security.x509.InhibitAnyPolicyExtension;
import sun.security.x509.InvalidityDateExtension;
import sun.security.x509.IssuerAlternativeNameExtension;
import sun.security.x509.IssuingDistributionPointExtension;
import sun.security.x509.NameConstraintsExtension;
import sun.security.x509.PolicyConstraintsExtension;
import sun.security.x509.PolicyMappingsExtension;
import sun.security.x509.PrivateKeyUsageExtension;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.SubjectInfoAccessExtension;
import sun.security.x509.SubjectKeyIdentifierExtension;

public class ApiGetCertInfoByOid
extends BaseExternalApi<String, String> {
    int paramNumber = 2;

    public String execute(String ... params) throws Exception {
        this.nullPointerIntercept(params);
        if (params.length != this.paramNumber) {
            throw new SOR_ParameterNotSupportedException("SOF_getCertInfoByOid: the number of params is incorrect");
        }
        String cert = params[0];
        String oid = params[1];
        this.checkBase64(cert);
        X509Certificate x509Certificate = CertUtils.convert2Certificate(Base64Utils.decode(params[0]));
        try {
            byte[] tbsCertBytes = x509Certificate.getTBSCertificate();
            TBSCertificate tbsCertificate = TBSCertificate.getInstance(tbsCertBytes);
            Extensions extensions = tbsCertificate.getExtensions();
            if (extensions == null) {
                throw new SOR_CertEncodeException("parse the certification error, all of the extension is null");
            }
            ASN1ObjectIdentifier extOid = new ASN1ObjectIdentifier(oid);
            Extension extension = extensions.getExtension(extOid);
            if (extension == null || extension.getExtnValue() == null) {
                throw new SOR_CertEncodeException("the oid of Extension is not found or in cert of Extensions not contain of the oid");
            }
            byte[] extValue = extension.getExtnValue().getOctets();
            if (extOid.equals(Extension.subjectDirectoryAttributes)) {
                StringBuffer result = new StringBuffer();
                SubjectDirectoryAttributes subjectDirectoryAttributes = SubjectDirectoryAttributes.getInstance(extValue);
                Vector attributes = subjectDirectoryAttributes.getAttributes();
                for (Attribute attribute : attributes) {
                    result.append("id:");
                    result.append(attribute.getAttrType().getId());
                    result.append("value:");
                    result.append(Functions.toHexString(attribute.getAttrValues().getObjectAt(0).toASN1Primitive().getEncoded()));
                    result.append(";");
                }
                return result.toString();
            }
            if (extOid.equals(Extension.subjectKeyIdentifier)) {
                SubjectKeyIdentifierExtension subKeyIdExt = new SubjectKeyIdentifierExtension(extension.isCritical(), extValue);
                return subKeyIdExt.toString();
            }
            if (extOid.equals(Extension.keyUsage)) {
                KeyUsage keyUsage = KeyUsage.fromExtensions(extensions);
                String keyUsageValue = keyUsage.toString();
                return keyUsageValue;
            }
            if (extOid.equals(Extension.privateKeyUsagePeriod)) {
                PrivateKeyUsageExtension privateKeyUsageExtension = new PrivateKeyUsageExtension(extension.isCritical(), extValue);
                return privateKeyUsageExtension.toString();
            }
            if (extOid.equals(Extension.subjectAlternativeName)) {
                SubjectAlternativeNameExtension subjectAltName = new SubjectAlternativeNameExtension((Boolean)extension.isCritical(), extValue);
                return subjectAltName.toString();
            }
            if (extOid.equals(Extension.issuerAlternativeName)) {
                IssuerAlternativeNameExtension issuerAltName = new IssuerAlternativeNameExtension((Boolean)extension.isCritical(), extValue);
                return issuerAltName.toString();
            }
            if (extOid.equals(Extension.basicConstraints)) {
                BasicConstraintsExtension basicConstraintsExtension = new BasicConstraintsExtension((Boolean)extension.isCritical(), extValue);
                return basicConstraintsExtension.toString();
            }
            if (extOid.equals(Extension.cRLNumber)) {
                CRLNumberExtension crlNumberExtension = new CRLNumberExtension(extension.isCritical(), extValue);
                return crlNumberExtension.toString();
            }
            if (extOid.equals(Extension.reasonCode)) {
                CRLReasonCodeExtension reasonCodeExtension = new CRLReasonCodeExtension((Boolean)extension.isCritical(), extValue);
                return reasonCodeExtension.toString();
            }
            if (extOid.equals(Extension.instructionCode)) {
                return "the value of oid can not parsed ";
            }
            if (extOid.equals(Extension.invalidityDate)) {
                InvalidityDateExtension invalidityDateExtension = new InvalidityDateExtension((Boolean)extension.isCritical(), extValue);
                return invalidityDateExtension.toString();
            }
            if (extOid.equals(Extension.deltaCRLIndicator)) {
                DeltaCRLIndicatorExtension deltaCrlIndicatorExtension = new DeltaCRLIndicatorExtension(extension.isCritical(), extValue);
                return deltaCrlIndicatorExtension.toString();
            }
            if (extOid.equals(Extension.issuingDistributionPoint)) {
                IssuingDistributionPointExtension issueDistPoint = new IssuingDistributionPointExtension(extension.isCritical(), extValue);
                return issueDistPoint.toString();
            }
            if (extOid.equals(Extension.certificateIssuer)) {
                CertificateIssuerExtension certificateIssuerExtension = new CertificateIssuerExtension(extension.isCritical(), extValue);
                return certificateIssuerExtension.toString();
            }
            if (extOid.equals(Extension.nameConstraints)) {
                NameConstraintsExtension nameConstraintsExtension = new NameConstraintsExtension(extension.isCritical(), extValue);
                return nameConstraintsExtension.toString();
            }
            if (extOid.equals(Extension.cRLDistributionPoints)) {
                CRLDistributionPointsExtension crlDistributionPointsExtension = new CRLDistributionPointsExtension((Boolean)extension.isCritical(), extValue);
                return crlDistributionPointsExtension.toString();
            }
            if (extOid.equals(Extension.certificatePolicies)) {
                CertificatePoliciesExtension certificatePolicies = new CertificatePoliciesExtension((Boolean)extension.isCritical(), extValue);
                return certificatePolicies.toString();
            }
            if (extOid.equals(Extension.policyMappings)) {
                PolicyMappingsExtension policyMappingsExtension = new PolicyMappingsExtension(extension.isCritical(), extValue);
                return policyMappingsExtension.toString();
            }
            if (extOid.equals(Extension.authorityKeyIdentifier)) {
                AuthorityKeyIdentifierExtension authKeyId = new AuthorityKeyIdentifierExtension(extension.isCritical(), extValue);
                return authKeyId.toString();
            }
            if (extOid.equals(Extension.policyConstraints)) {
                PolicyConstraintsExtension policyConstraintsExtension = new PolicyConstraintsExtension(extension.isCritical(), extValue);
                return policyConstraintsExtension.toString();
            }
            if (extOid.equals(Extension.extendedKeyUsage)) {
                ExtendedKeyUsageExtension keyUsageExtension = new ExtendedKeyUsageExtension((Boolean)extension.isCritical(), extValue);
                return keyUsageExtension.toString();
            }
            if (extOid.equals(Extension.freshestCRL)) {
                FreshestCRLExtension freshestCrlExtension = new FreshestCRLExtension((Boolean)extension.isCritical(), extValue);
                return freshestCrlExtension.toString();
            }
            if (extOid.equals(Extension.inhibitAnyPolicy)) {
                InhibitAnyPolicyExtension inhibitAnyPolicyExtension = new InhibitAnyPolicyExtension(extension.isCritical(), extValue);
                return inhibitAnyPolicyExtension.toString();
            }
            if (extOid.equals(Extension.authorityInfoAccess)) {
                AuthorityInfoAccessExtension authorityInfoAccessExtension = new AuthorityInfoAccessExtension(extension.isCritical(), extValue);
                return authorityInfoAccessExtension.toString();
            }
            if (extOid.equals(Extension.subjectInfoAccess)) {
                SubjectInfoAccessExtension subjectInfoAccessExtension = new SubjectInfoAccessExtension(extension.isCritical(), extValue);
                return subjectInfoAccessExtension.toString();
            }
            return Functions.toHexString(extValue);
        }
        catch (Exception e) {
            throw new SOR_CertEncodeException(e.getMessage());
        }
    }
}

