/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.api.certinfo;

import com.xdja.svs.common.Log;
import com.xdja.svs.utils.TimeUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.PolicyMappings;
import org.bouncycastle.asn1.x509.PrivateKeyUsagePeriod;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.util.encoders.Hex;
import sun.security.pkcs11.wrapper.Functions;
import sun.security.x509.CertificatePoliciesExtension;
import sun.security.x509.ExtendedKeyUsageExtension;
import sun.security.x509.PolicyConstraintsExtension;

public enum CertInfoType {
    CERT_VERSION(1){

        @Override
        public String parseInfo(byte[] param) {
            int i = ASN1Integer.getInstance(param).getValue().intValue();
            if (i == 0) {
                return String.valueOf(1);
            }
            if (i == 1) {
                return String.valueOf(2);
            }
            return String.valueOf(3);
        }
    }
    ,
    CERT_SERIAL(2){

        @Override
        public String parseInfo(byte[] param) {
            return ASN1Integer.getInstance(param).getValue().toString(16);
        }
    }
    ,
    CERT_ISSUER(5){

        @Override
        public String parseInfo(byte[] param) {
            return String.valueOf(X500Name.getInstance(param));
        }
    }
    ,
    CERT_VALID_TIME(6){

        @Override
        public String parseInfo(byte[] param) {
            ASN1Sequence sequence = DERSequence.getInstance(param);
            ASN1UTCTime notBeforeTime = ASN1UTCTime.getInstance(sequence.getObjectAt(0));
            ASN1UTCTime notAfterTime = ASN1UTCTime.getInstance(sequence.getObjectAt(1));
            StringBuilder certPeriod = new StringBuilder();
            try {
                certPeriod.append("\u5f00\u59cb\u65f6\u95f4:");
                certPeriod.append(TimeUtils.convert2LocaleTime(notBeforeTime.getDate()));
                certPeriod.append(" \u7ed3\u675f\u65f6\u95f4:");
                certPeriod.append(TimeUtils.convert2LocaleTime(notAfterTime.getDate()));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            return certPeriod.toString();
        }
    }
    ,
    CERT_SUBJECT(7){

        @Override
        public String parseInfo(byte[] param) {
            return String.valueOf(X500Name.getInstance(param));
        }
    }
    ,
    CERT_PUBLIC_KEY_INFO(8){

        @Override
        public String parseInfo(byte[] param) {
            SubjectPublicKeyInfo publicKeyInfo = SubjectPublicKeyInfo.getInstance(param);
            StringBuilder result = new StringBuilder();
            AlgorithmIdentifier algId = publicKeyInfo.getAlgorithm();
            result.append("\u7b97\u6cd5id:");
            result.append(algId.getAlgorithm().getId());
            result.append(" \u7b97\u6cd5\u6807\u8bc6id:");
            ASN1ObjectIdentifier algOid = ASN1ObjectIdentifier.getInstance(algId.getParameters());
            result.append(algOid.getId());
            result.append(" \u516c\u94a5\u503c:");
            String pubKey = Functions.toHexString(publicKeyInfo.getPublicKeyData().getOctets());
            result.append(pubKey);
            return result.toString();
        }
    }
    ,
    CERT_EXTENSION_INFO(9){

        @Override
        public String parseInfo(byte[] param) {
            StringBuilder result = new StringBuilder();
            Extensions extensions = Extensions.getInstance(param);
            Enumeration enumeration = extensions.oids();
            while (enumeration.hasMoreElements()) {
                ASN1ObjectIdentifier extension = (ASN1ObjectIdentifier)enumeration.nextElement();
                result.append(extension.getId());
                result.append("\r\n");
            }
            return result.toString();
        }
    }
    ,
    CERT_ISSUER_KEY_OID(17){

        @Override
        public String parseInfo(byte[] param) {
            ASN1OctetString realByte = DEROctetString.getInstance(param);
            AuthorityKeyIdentifier authorityKeyIdentifier = AuthorityKeyIdentifier.getInstance(realByte.getOctets());
            BigInteger serialNo = authorityKeyIdentifier.getAuthorityCertSerialNumber();
            byte[] keyIds = authorityKeyIdentifier.getKeyIdentifier();
            GeneralNames names = authorityKeyIdentifier.getAuthorityCertIssuer();
            StringBuilder buffer = new StringBuilder();
            if (serialNo != null) {
                buffer.append("serialNo:" + serialNo.toString(16) + "; ");
            }
            if (keyIds != null) {
                buffer.append("keyId:" + Functions.toHexString(keyIds) + "; ");
            }
            if (names != null) {
                buffer.append(names.toString());
            }
            return buffer.toString();
        }
    }
    ,
    CERT_OWNER_KEY_OID(18){

        @Override
        public String parseInfo(byte[] param) {
            ASN1OctetString realByte = DEROctetString.getInstance(param);
            SubjectKeyIdentifier subjectKeyIdentifier = SubjectKeyIdentifier.getInstance(realByte.getOctets());
            byte[] subKeyId = subjectKeyIdentifier.getKeyIdentifier();
            StringBuilder buffer = new StringBuilder();
            if (subKeyId != null) {
                buffer.append("\u4f7f\u7528\u8005\u5bc6\u94a5\u6807\u8bc6\u7b26:" + Functions.toHexString(subKeyId) + "; ");
            }
            return buffer.toString();
        }
    }
    ,
    KEY_USE(19){

        @Override
        public String parseInfo(byte[] param) {
            ASN1OctetString realByte = DEROctetString.getInstance(param);
            KeyUsage keyUsage = KeyUsage.getInstance(realByte.getOctets());
            return new String(Hex.encode(keyUsage.getBytes()));
        }
    }
    ,
    PRIVATE_KEY_VALID_DATE(20){

        @Override
        public String parseInfo(byte[] param) {
            ASN1OctetString realByte = DEROctetString.getInstance(param);
            PrivateKeyUsagePeriod keyUsagePeriod = PrivateKeyUsagePeriod.getInstance(realByte.getOctets());
            StringBuilder buffer = new StringBuilder();
            buffer.append("NotAfter:");
            try {
                buffer.append(TimeUtils.convert2LocaleTime(keyUsagePeriod.getNotAfter().getDate()));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            buffer.append("NotBefore:");
            try {
                buffer.append(TimeUtils.convert2LocaleTime(keyUsagePeriod.getNotBefore().getDate()));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            return buffer.toString();
        }
    }
    ,
    CERT_POLICY(21){

        @Override
        public String parseInfo(byte[] param) {
            ASN1OctetString realByte = DEROctetString.getInstance(param);
            try {
                CertificatePoliciesExtension certificatePolicies = new CertificatePoliciesExtension((Boolean)false, realByte.getOctets());
                return certificatePolicies.toString();
            }
            catch (IOException e) {
                Log.print("parse CertificatePoliciesExtension error");
                return "parse error";
            }
        }
    }
    ,
    POLICY_MAPPING(22){

        @Override
        public String parseInfo(byte[] param) {
            ASN1OctetString realByte = DEROctetString.getInstance(param);
            PolicyMappings policyMappings = PolicyMappings.getInstance(realByte.getOctets());
            return String.valueOf(policyMappings);
        }
    }
    ,
    BASIC_LIMIT(23){

        @Override
        public String parseInfo(byte[] param) {
            ASN1OctetString realByte = DEROctetString.getInstance(param);
            BasicConstraints basicConstraints = BasicConstraints.getInstance(realByte.getOctets());
            return basicConstraints.toString();
        }
    }
    ,
    POLICY_LIMIT(24){

        @Override
        public String parseInfo(byte[] param) {
            ASN1OctetString realByte = DEROctetString.getInstance(param);
            try {
                PolicyConstraintsExtension policyConstraintsExtension = new PolicyConstraintsExtension(false, realByte.getOctets());
                return policyConstraintsExtension.toString();
            }
            catch (IOException e) {
                Log.print("parse PolicyConstraintsExtension error");
                return "parse error";
            }
        }
    }
    ,
    KEY_USAGE_EXT(25){

        @Override
        public String parseInfo(byte[] param) {
            ASN1OctetString realByte = DEROctetString.getInstance(param);
            try {
                ExtendedKeyUsageExtension keyUsageExtension = new ExtendedKeyUsageExtension((Boolean)false, realByte.getOctets());
                return keyUsageExtension.toString();
            }
            catch (IOException e) {
                Log.print("parse ExtendedKeyUsageExtension error");
                return "parse error";
            }
        }
    }
    ,
    CRL_PUBLISH_POINT(26){

        @Override
        public String parseInfo(byte[] param) {
            ASN1OctetString realByte = DEROctetString.getInstance(param);
            CRLDistPoint crlDistPoint = CRLDistPoint.getInstance(realByte.getOctets());
            return crlDistPoint.toString();
        }
    }
    ,
    NETSCAPE_CERT_TYPE(27){

        @Override
        public String parseInfo(byte[] param) {
            return "unsupported";
        }
    }
    ,
    SELF_DEFINED_EXTENSION_INFO(28){

        @Override
        public String parseInfo(byte[] param) {
            ASN1OctetString realByte = DEROctetString.getInstance(param);
            return Hex.toHexString(realByte.getOctets());
        }
    }
    ,
    CERT_ISSUER_CN(33){

        @Override
        public String parseInfo(byte[] param) {
            ASN1OctetString realByte = DEROctetString.getInstance(param);
            if (realByte == null) {
                Log.print("CERT_ISSUER_CN : parse error");
                return "parse error";
            }
            return new String(realByte.getOctets());
        }
    }
    ,
    CERT_ISSUER_O(34){

        @Override
        public String parseInfo(byte[] param) {
            ASN1OctetString realByte = DEROctetString.getInstance(param);
            if (realByte == null) {
                Log.print("CERT_ISSUER_O : parse error");
                return "parse error";
            }
            return new String(realByte.getOctets());
        }
    }
    ,
    CERT_ISSUER_OU(35){

        @Override
        public String parseInfo(byte[] param) {
            ASN1OctetString realByte = DEROctetString.getInstance(param);
            if (realByte == null) {
                Log.print("CERT_ISSUER_OU : parse error");
                return "parse error";
            }
            return new String(realByte.getOctets());
        }
    }
    ,
    CERT_SUBJECT_CN(49){

        @Override
        public String parseInfo(byte[] param) {
            ASN1OctetString realByte = DEROctetString.getInstance(param);
            if (realByte == null) {
                Log.print("CERT_SUBJECT_CN : parse error");
                return "parse error";
            }
            return new String(realByte.getOctets());
        }
    }
    ,
    CERT_SUBJECT_O(50){

        @Override
        public String parseInfo(byte[] param) {
            ASN1OctetString realByte = DEROctetString.getInstance(param);
            if (realByte == null) {
                Log.print("CERT_SUBJECT_O : parse error");
                return "parse error";
            }
            return new String(realByte.getOctets());
        }
    }
    ,
    CERT_SUBJECT_OU(51){

        @Override
        public String parseInfo(byte[] param) {
            ASN1OctetString realByte = DEROctetString.getInstance(param);
            if (realByte == null) {
                Log.print("CERT_SUBJECT_OU : parse error");
                return "parse error";
            }
            return new String(realByte.getOctets());
        }
    }
    ,
    CERT_SUBJECT_EMAIL(52){

        @Override
        public String parseInfo(byte[] param) {
            ASN1OctetString realByte = DEROctetString.getInstance(param);
            if (realByte == null) {
                Log.print("CERT_SUBJECT_EMAIL : parse error");
                return "parse error";
            }
            return new String(realByte.getOctets());
        }
    }
    ,
    CERT_NOT_BEFORE_TIME(53){

        @Override
        public String parseInfo(byte[] param) {
            try {
                return TimeUtils.convert2LocaleTime(ASN1UTCTime.getInstance(param).getDate());
            }
            catch (ParseException e) {
                e.printStackTrace();
                return new Date().toString();
            }
        }
    }
    ,
    CERT_NOT_AFTER_TIME(54){

        @Override
        public String parseInfo(byte[] param) {
            try {
                return TimeUtils.convert2LocaleTime(ASN1UTCTime.getInstance(param).getDate());
            }
            catch (ParseException e) {
                e.printStackTrace();
                return new Date().toString();
            }
        }
    };

    private int typeId;

    private CertInfoType(int typeId) {
        this.typeId = typeId;
    }

    public static boolean isSupport(int typeId) {
        return CertInfoType.matchType(typeId) != null;
    }

    public static CertInfoType matchType(int typeId) {
        CertInfoType[] certInfoTypes;
        for (CertInfoType certInfoType : certInfoTypes = CertInfoType.values()) {
            if (certInfoType.typeId != typeId) continue;
            return certInfoType;
        }
        return null;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public abstract String parseInfo(byte[] var1);
}

