/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.api.encryptdata;

import com.xdja.svs.Session;
import com.xdja.svs.alg.EncAlg;
import com.xdja.svs.api.BaseExternalApi;
import com.xdja.svs.execption.SOR_ParameterNotSupportedException;
import com.xdja.svs.execption.ServiceException;
import com.xdja.svs.gmt.ContentInfoUtils;
import com.xdja.svs.protocol.IRequest;
import com.xdja.svs.protocol.encryptdata.request.MultiDecryptDataFinalRequest;
import com.xdja.svs.protocol.encryptdata.request.MultiDecryptDataInitRequest;
import com.xdja.svs.protocol.encryptdata.request.MultiDecryptDataUpdateRequest;
import com.xdja.svs.protocol.encryptdata.request.SingleDecryptDataRequest;
import com.xdja.svs.protocol.encryptdata.response.MultiDecryptDataFinalResponse;
import com.xdja.svs.protocol.encryptdata.response.MultiDecryptDataInitResponse;
import com.xdja.svs.protocol.encryptdata.response.MultiDecryptDataUpdateResponse;
import com.xdja.svs.protocol.encryptdata.response.SingleDecryptDataResponse;
import com.xdja.svs.utils.Base64Utils;
import com.xdja.svs.utils.EmptyUtils;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;

public class ApiDecryptData
extends BaseExternalApi<String, byte[]> {
    Session session;

    public ApiDecryptData(Session session) throws SOR_ParameterNotSupportedException {
        this.session = session;
        if (EmptyUtils.isEmpty(session.getAppName())) {
            throw new SOR_ParameterNotSupportedException("SOF_decryptData:appName is null");
        }
        if (!EncAlg.matchEncAlg(session.getEncAlg())) {
            throw new SOR_ParameterNotSupportedException("SOF_decryptData:enc alg is not support,please set encAlg for session");
        }
    }

    public byte[] execute(String ... params) throws Exception {
        this.nullPointerIntercept(params);
        String certSN = params[0];
        X509Certificate encCert = this.session.getEncCert();
        if (encCert == null) {
            throw new SOR_ParameterNotSupportedException("SOF_decryptFile:session 's enc cert is null");
        }
        String sessionSN = encCert.getSerialNumber().toString();
        if (!sessionSN.equals(certSN)) {
            throw new SOR_ParameterNotSupportedException("SOF_decryptFile:please check the param,certSn is error");
        }
        this.checkBase64(params[1]);
        byte[] inData = Base64Utils.decode(params[1]);
        if (inData.length <= MAX_DEC_BUFFER) {
            return this.singleDecryptData(this.session, inData);
        }
        return this.multiDecryptData(this.session, inData);
    }

    private byte[] multiDecryptData(Session session, byte[] inData) throws Exception {
        byte[] cipherData = ContentInfoUtils.getDataCipher(inData);
        byte[] symmKeyData = ContentInfoUtils.getSymmKey(inData);
        Object ivData = ContentInfoUtils.getIv(inData);
        MultiDecryptDataInitResponse multiDecryptDataInitResponse = this.decryptDataInit(session, symmKeyData, (byte[])ivData);
        long symKeyID = multiDecryptDataInitResponse.getSymKeyID().getValue().longValue();
        int plainTextLength = 0;
        int totalLength = cipherData.length;
        int position = 0;
        ArrayList<byte[]> plainTextList = new ArrayList<byte[]>();
        while (true) {
            byte[] inDataTmp;
            if (totalLength >= MAX_DEC_BUFFER) {
                inDataTmp = new byte[MAX_DEC_BUFFER];
                System.arraycopy(cipherData, position * MAX_DEC_BUFFER, inDataTmp, 0, MAX_DEC_BUFFER);
            } else {
                inDataTmp = new byte[totalLength];
                System.arraycopy(cipherData, position * MAX_DEC_BUFFER, inDataTmp, 0, totalLength);
            }
            MultiDecryptDataUpdateResponse multiDecryptDataUpdateResponse = this.decryptDataUpdate(session, symKeyID, inDataTmp, (byte[])ivData);
            if (multiDecryptDataUpdateResponse != null && multiDecryptDataUpdateResponse.isSuccess()) {
                ASN1OctetString responseIv = multiDecryptDataUpdateResponse.getIv();
                ivData = responseIv != null ? responseIv.getOctets() : null;
                ASN1OctetString realData = multiDecryptDataUpdateResponse.getPlaintext();
                byte[] data = realData.getOctets();
                plainTextLength += data.length;
                plainTextList.add(data);
            }
            if (totalLength <= MAX_DEC_BUFFER) break;
            ++position;
            totalLength -= MAX_DEC_BUFFER;
        }
        this.decryptDataFinal(session, symKeyID);
        byte[] origins = new byte[plainTextLength];
        int elementLength = 0;
        for (byte[] bytes : plainTextList) {
            System.arraycopy(bytes, 0, origins, elementLength, bytes.length);
            elementLength += bytes.length;
        }
        return origins;
    }

    private MultiDecryptDataInitResponse decryptDataInit(Session session, byte[] encKey, byte[] iv) throws Exception {
        ASN1Sequence sequence = this.getSequence(session, new MultiDecryptDataInitRequest(session, encKey, iv));
        MultiDecryptDataInitResponse multiDecryptDataInitResponse = new MultiDecryptDataInitResponse(sequence.getObjectAt(2));
        if (multiDecryptDataInitResponse == null || !multiDecryptDataInitResponse.isSuccess()) {
            throw new ServiceException("DecryptDataInit : response is null");
        }
        return multiDecryptDataInitResponse;
    }

    public MultiDecryptDataUpdateResponse decryptDataUpdate(Session session, long symKeyID, byte[] cipherText, byte[] iv) throws Exception {
        ASN1Sequence sequence = this.getSequence(session, new MultiDecryptDataUpdateRequest(session, symKeyID, cipherText, iv));
        MultiDecryptDataUpdateResponse multiDecryptDataUpdateResponse = new MultiDecryptDataUpdateResponse(sequence.getObjectAt(2));
        if (multiDecryptDataUpdateResponse == null || !multiDecryptDataUpdateResponse.isSuccess()) {
            throw new ServiceException("decryptDataUpdate: response is null");
        }
        return multiDecryptDataUpdateResponse;
    }

    public MultiDecryptDataFinalResponse decryptDataFinal(Session session, long symKeyID) throws Exception {
        ASN1Sequence sequence = this.getSequence(session, new MultiDecryptDataFinalRequest(symKeyID));
        MultiDecryptDataFinalResponse multiDecryptDataFinalResponse = new MultiDecryptDataFinalResponse(sequence.getObjectAt(2));
        if (multiDecryptDataFinalResponse == null || !multiDecryptDataFinalResponse.isSuccess()) {
            throw new ServiceException("decryptDataFinal: response is null");
        }
        return multiDecryptDataFinalResponse;
    }

    private ASN1Sequence getSequence(Session session, IRequest request) throws Exception {
        ASN1Sequence sequence = session.getSocketFactory().processing(session.getSocketFd(), request);
        if (sequence == null) {
            throw new ServiceException("singleDecryptData : response is null");
        }
        return sequence;
    }

    private byte[] singleDecryptData(Session session, byte[] inData) throws Exception {
        DEROctetString dataCipher = new DEROctetString(ContentInfoUtils.getDataCipher(inData));
        DEROctetString symKey = new DEROctetString(ContentInfoUtils.getSymmKey(inData));
        DEROctetString iv = new DEROctetString(ContentInfoUtils.getIv(inData));
        int keyIndex = session.getPrivateKeyIndex();
        String passWd = session.getPrivateKeyPwd();
        long encAlg = session.getEncAlg();
        SingleDecryptDataRequest singleDecryptDataRequest = new SingleDecryptDataRequest(keyIndex, passWd, encAlg, symKey, dataCipher, iv);
        ASN1Sequence sequence = this.getSequence(session, singleDecryptDataRequest);
        SingleDecryptDataResponse encryptDataResp = new SingleDecryptDataResponse(sequence.getObjectAt(2));
        if (encryptDataResp == null || !encryptDataResp.isSuccess()) {
            throw new ServiceException("singleDecryptData : service internal error ");
        }
        return encryptDataResp.getPlainData();
    }
}

