/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.api.encryptdata;

import com.xdja.svs.Session;
import com.xdja.svs.alg.EncAlg;
import com.xdja.svs.api.BaseExternalApi;
import com.xdja.svs.common.Log;
import com.xdja.svs.execption.SOR_ParameterNotSupportedException;
import com.xdja.svs.execption.ServiceException;
import com.xdja.svs.gmt.ContentInfoUtils;
import com.xdja.svs.protocol.IRequest;
import com.xdja.svs.protocol.encryptdata.request.MultiEncryptDataFinalRequest;
import com.xdja.svs.protocol.encryptdata.request.MultiEncryptDataInitRequest;
import com.xdja.svs.protocol.encryptdata.request.MultiEncryptDataUpdateRequest;
import com.xdja.svs.protocol.encryptdata.request.SingleEncryptDataRequest;
import com.xdja.svs.protocol.encryptdata.response.MultiEncryptDataFinalResponse;
import com.xdja.svs.protocol.encryptdata.response.MultiEncryptDataInitResponse;
import com.xdja.svs.protocol.encryptdata.response.MultiEncryptDataUpdateResponse;
import com.xdja.svs.protocol.encryptdata.response.SingleEncryptDataResponse;
import com.xdja.svs.utils.Base64Utils;
import com.xdja.svs.utils.CertUtils;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import sun.security.pkcs11.wrapper.Functions;

public class ApiEncryptData
extends BaseExternalApi<String, String> {
    Session session;
    byte[] plainText;

    public ApiEncryptData(Session session, String inData) throws SOR_ParameterNotSupportedException {
        this(session, inData.getBytes());
    }

    public ApiEncryptData(Session session, byte[] inData) throws SOR_ParameterNotSupportedException {
        this.session = session;
        if (inData == null || inData.length <= 0) {
            throw new SOR_ParameterNotSupportedException("SOF_encryptData:inData is null");
        }
        this.plainText = inData;
        if (this.plainText == null || this.plainText.length <= 0) {
            throw new SOR_ParameterNotSupportedException("SOF_encryptData: data is null");
        }
        if (!EncAlg.matchEncAlg(session.getEncAlg())) {
            throw new SOR_ParameterNotSupportedException("SOF_encryptData:enc alg is not support,please set encAlg for session");
        }
    }

    public String execute(String ... params) throws Exception {
        this.nullPointerIntercept(params);
        String encodeCert = params[0];
        this.checkBase64(encodeCert);
        X509Certificate x509Certificate = CertUtils.convert2Certificate(Base64Utils.decode(encodeCert));
        if (this.plainText.length <= MAX_ENC_BUFFER) {
            return this.singleEncryptData(this.session, x509Certificate, this.plainText);
        }
        return this.encryptDataMulti(this.session, x509Certificate, this.plainText);
    }

    public String encryptDataMulti(Session session, X509Certificate certificate, byte[] inData) throws Exception {
        int totalLength;
        MultiEncryptDataInitResponse multiEncryptDataInitResponse = ApiEncryptData.encryptDataInit(session, certificate.getPublicKey());
        long symKeyID = multiEncryptDataInitResponse.getSymKeyID().getValue().longValue();
        ASN1OctetString defaultIv = multiEncryptDataInitResponse.getIv();
        ASN1OctetString iv = multiEncryptDataInitResponse.getIv();
        int plainTextLength = 0;
        ArrayList<byte[]> cipherTextList = new ArrayList<byte[]>();
        int position = 0;
        for (totalLength = inData.length; totalLength > MAX_ENC_BUFFER; totalLength -= MAX_ENC_BUFFER) {
            byte[] inDataTmp = new byte[MAX_ENC_BUFFER];
            System.arraycopy(inData, position * MAX_ENC_BUFFER, inDataTmp, 0, MAX_ENC_BUFFER);
            MultiEncryptDataUpdateResponse multiEncryptDataUpdateResponse = ApiEncryptData.encryptDataUpdate(session, symKeyID, inDataTmp, iv);
            byte[] cipherArray = multiEncryptDataUpdateResponse.getCipherText().getOctets();
            iv = multiEncryptDataUpdateResponse.getIv();
            cipherTextList.add(cipherArray);
            plainTextLength += cipherArray.length;
            if (totalLength <= MAX_ENC_BUFFER) break;
            ++position;
        }
        if (totalLength % MAX_ENC_BUFFER == 0) {
            ApiEncryptData.encryptDataFinal(session, symKeyID, null, iv);
        } else {
            byte[] remainData = new byte[totalLength];
            System.arraycopy(inData, position * MAX_ENC_BUFFER, remainData, 0, totalLength);
            MultiEncryptDataFinalResponse multiEncryptDataFinalResponse = ApiEncryptData.encryptDataFinal(session, symKeyID, remainData, iv);
            if (multiEncryptDataFinalResponse != null && multiEncryptDataFinalResponse.isSuccess()) {
                byte[] bytes = multiEncryptDataFinalResponse.getCipherText().getOctets();
                plainTextLength += bytes.length;
                cipherTextList.add(bytes);
            }
        }
        byte[] cipherData = new byte[plainTextLength];
        int elementLength = 0;
        for (byte[] bytes : cipherTextList) {
            System.arraycopy(bytes, 0, cipherData, elementLength, bytes.length);
            elementLength += bytes.length;
        }
        AlgorithmIdentifier algorithmIdentifier = EncAlg.find(session.getEncAlg()).createOid();
        return ContentInfoUtils.packEncryptedData(certificate, multiEncryptDataInitResponse.getSymKey().getOctets(), cipherData, defaultIv, algorithmIdentifier);
    }

    public static MultiEncryptDataInitResponse encryptDataInit(Session session, PublicKey publicKey) throws Exception {
        ASN1Sequence sequence = ApiEncryptData.getSequence(session, new MultiEncryptDataInitRequest(publicKey, session.getEncAlg()));
        MultiEncryptDataInitResponse multiEncryptDataInitResponse = new MultiEncryptDataInitResponse(sequence.getObjectAt(2));
        if (multiEncryptDataInitResponse == null || !multiEncryptDataInitResponse.isSuccess()) {
            throw new ServiceException("encryptDataInit : service internal error");
        }
        return multiEncryptDataInitResponse;
    }

    public static MultiEncryptDataUpdateResponse encryptDataUpdate(Session session, long symKeyID, byte[] inData, ASN1OctetString iv) throws Exception {
        ASN1Sequence sequence = ApiEncryptData.getSequence(session, new MultiEncryptDataUpdateRequest(symKeyID, inData, iv));
        MultiEncryptDataUpdateResponse multiEncryptDataUpdateResponse = new MultiEncryptDataUpdateResponse((int)session.getEncAlg(), sequence.getObjectAt(2));
        if (multiEncryptDataUpdateResponse == null || !multiEncryptDataUpdateResponse.isSuccess()) {
            throw new ServiceException("encryptDataUpdate : service internal error");
        }
        return multiEncryptDataUpdateResponse;
    }

    public static MultiEncryptDataFinalResponse encryptDataFinal(Session session, long symKeyID, byte[] inData, ASN1OctetString iv) throws Exception {
        ASN1Sequence sequence = ApiEncryptData.getSequence(session, new MultiEncryptDataFinalRequest(symKeyID, inData, iv));
        MultiEncryptDataFinalResponse multiEncryptDataFinalResponse = new MultiEncryptDataFinalResponse(sequence.getObjectAt(2));
        if (multiEncryptDataFinalResponse == null || !multiEncryptDataFinalResponse.isSuccess()) {
            throw new ServiceException("encryptDataFinal : service internal error");
        }
        return multiEncryptDataFinalResponse;
    }

    private static ASN1Sequence getSequence(Session session, IRequest request) throws Exception {
        ASN1Sequence sequence = session.getSocketFactory().processing(session.getSocketFd(), request);
        if (sequence == null) {
            throw new ServiceException("SOF_encryptData : response is null");
        }
        return sequence;
    }

    private String singleEncryptData(Session session, X509Certificate x509Certificate, byte[] inData) throws Exception {
        long pubkeyType = 0L;
        if (CertUtils.isRsa(x509Certificate)) {
            pubkeyType = 1L;
        }
        PublicKey publicKey = x509Certificate.getPublicKey();
        int encAlg = (int)session.getEncAlg();
        byte[] randomIv = "1234567812345678".getBytes();
        SingleEncryptDataRequest singleEncryptDataRequest = new SingleEncryptDataRequest(SubjectPublicKeyInfo.getInstance(publicKey.getEncoded()), pubkeyType, encAlg, inData, randomIv);
        ASN1Sequence sequence = session.getSocketFactory().processing(this.session.getSocketFd(), singleEncryptDataRequest);
        if (sequence == null) {
            throw new ServiceException("SOF_encryptData : service internal error");
        }
        SingleEncryptDataResponse singleEncryptDataResponse = new SingleEncryptDataResponse(encAlg, sequence.getObjectAt(2));
        if (singleEncryptDataResponse.isSuccess()) {
            byte[] cipherTextBytes = singleEncryptDataResponse.getCipherText().getOctets();
            byte[] symKeyBytes = singleEncryptDataResponse.getSymKey().getOctets();
            ASN1OctetString iv = singleEncryptDataResponse.getIv();
            if (iv != null) {
                Log.print("\u52a0\u5bc6\u540eIV\u8fd4\u56de:" + Functions.toHexString(iv.getOctets()));
            }
            AlgorithmIdentifier algorithmIdentifier = EncAlg.find(encAlg).createOid();
            return ContentInfoUtils.packEncryptedData(x509Certificate, symKeyBytes, cipherTextBytes, iv, algorithmIdentifier);
        }
        throw new ServiceException("SOF_encryptData : service internal error ");
    }
}

