/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.api.encryptfile;

import com.xdja.svs.Session;
import com.xdja.svs.alg.EncAlg;
import com.xdja.svs.api.BaseExternalApi;
import com.xdja.svs.api.encryptdata.ApiDecryptData;
import com.xdja.svs.execption.SOR_ParameterNotSupportedException;
import com.xdja.svs.utils.EmptyUtils;
import com.xdja.svs.utils.FileUtils;

public class ApiDecryptFile
extends BaseExternalApi<String, Boolean> {
    Session session;

    public ApiDecryptFile(Session session) throws SOR_ParameterNotSupportedException {
        this.session = session;
        if (EmptyUtils.isEmpty(session.getAppName())) {
            throw new SOR_ParameterNotSupportedException("SOF_decryptFile:appName is null");
        }
        if (!EncAlg.matchEncAlg(session.getEncAlg())) {
            throw new SOR_ParameterNotSupportedException("SOF_decryptFile:enc alg is not support,please set encAlg for session");
        }
    }

    public Boolean execute(String ... params) throws Exception {
        this.nullPointerIntercept(params);
        String certSN = params[0];
        String srcPath = params[1];
        String distPath = params[2];
        FileUtils.fileIsExist(srcPath);
        FileUtils.deleteFile(distPath, false);
        String content = FileUtils.readFile2String(srcPath);
        byte[] originData = new ApiDecryptData(this.session).execute(certSN, content);
        if (originData == null || originData.length <= 0) {
            return false;
        }
        return FileUtils.write2File(originData, distPath);
    }
}

