/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.api.encryptfile;

import com.xdja.svs.Session;
import com.xdja.svs.alg.EncAlg;
import com.xdja.svs.api.BaseExternalApi;
import com.xdja.svs.api.encryptdata.ApiEncryptData;
import com.xdja.svs.execption.SOR_ParameterNotSupportedException;
import com.xdja.svs.execption.SOR_ReadFileException;
import com.xdja.svs.utils.FileUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;

public class ApiEncryptFile
extends BaseExternalApi<String, Boolean> {
    Session session;

    public ApiEncryptFile(Session session) throws SOR_ParameterNotSupportedException {
        this.session = session;
        if (!EncAlg.matchEncAlg(session.getEncAlg())) {
            throw new SOR_ParameterNotSupportedException("SOF_encryptFile:enc alg is not support,please set encAlg for session");
        }
    }

    public Boolean execute(String ... params) throws Exception {
        this.nullPointerIntercept(params);
        String encodeCert = params[0];
        this.checkBase64(encodeCert);
        String srcPath = params[1];
        String distPath = params[2];
        FileUtils.fileIsExist(srcPath);
        FileUtils.deleteFile(distPath, false);
        BufferedInputStream bufferedInputStream = null;
        int totalLength = 0;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(new File(srcPath)));
            totalLength = bufferedInputStream.available();
        }
        catch (Exception e) {
            try {
                throw new SOR_ReadFileException("the path of src file is error ");
            }
            catch (Throwable throwable) {
                FileUtils.close(bufferedInputStream);
                throw throwable;
            }
        }
        FileUtils.close(bufferedInputStream);
        if (totalLength > MAX_ENC_BUFFER) {
            byte[] plainData = FileUtils.readFile2Byte(srcPath);
            String envelop = new ApiEncryptData(this.session, plainData).execute(encodeCert);
            return FileUtils.write2File(envelop, distPath);
        }
        if (totalLength == 0) {
            throw new SOR_ReadFileException("file content is null");
        }
        byte[] plainData = FileUtils.readFile2Byte(srcPath);
        String envelopData = new ApiEncryptData(this.session, plainData).execute(encodeCert);
        return FileUtils.write2File(envelopData, distPath);
    }
}

