/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.api.getservercert;

import com.xdja.svs.Session;
import com.xdja.svs.api.BaseExternalApi;
import com.xdja.svs.execption.SOR_CertEncodeException;
import com.xdja.svs.execption.SOR_ParameterNotSupportedException;
import com.xdja.svs.utils.Base64Utils;
import java.security.cert.X509Certificate;

public class ApiGetServerCertificateByUsage
extends BaseExternalApi<Short, String> {
    public static final short ENCRYPT = 1;
    public static final short SIGNATURE = 2;
    Session session;

    public ApiGetServerCertificateByUsage(Session session) {
        this.session = session;
    }

    public String execute(Short ... shorts) throws Exception {
        short certType = shorts[0];
        if (certType == 1) {
            X509Certificate enc = this.session.getEncCert();
            if (null == enc) {
                throw new SOR_CertEncodeException("encrypt certificate is null");
            }
            return Base64Utils.encode(enc.getEncoded());
        }
        if (certType == 2) {
            X509Certificate sign = this.session.getSignCert();
            if (sign == null) {
                throw new SOR_CertEncodeException("sign certificate is null");
            }
            return Base64Utils.encode(sign.getEncoded());
        }
        throw new SOR_ParameterNotSupportedException("the param of short type is not support");
    }
}

