/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.api.hash;

import com.xdja.svs.Session;
import com.xdja.svs.alg.HashAlg;
import com.xdja.svs.api.BaseExternalApi;
import com.xdja.svs.execption.SOR_ParameterNotSupportedException;
import com.xdja.svs.execption.ServiceException;
import com.xdja.svs.protocol.hash.request.HashFinalRequest;
import com.xdja.svs.protocol.hash.request.HashInitRequest;
import com.xdja.svs.protocol.hash.request.HashUpdateRequest;
import com.xdja.svs.protocol.hash.response.HashFinalResponse;
import com.xdja.svs.protocol.hash.response.HashInitResponse;
import com.xdja.svs.protocol.hash.response.HashUpdateResponse;
import com.xdja.svs.utils.Base64Utils;
import com.xdja.svs.utils.CertUtils;
import com.xdja.svs.utils.EmptyUtils;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

public class ApiHash
extends BaseExternalApi<String, String> {
    Session session;

    public ApiHash(Session session) throws SOR_ParameterNotSupportedException {
        this.session = session;
        if (EmptyUtils.isEmpty(session.getAppName())) {
            throw new SOR_ParameterNotSupportedException("SOF_hash:appName is null");
        }
        X509Certificate signCert = session.getSignCert();
        if (signCert == null) {
            throw new SOR_ParameterNotSupportedException("SOF_hash:sign cert is not exist");
        }
        if (!HashAlg.matchedHashAlg(session.getHashAlg())) {
            throw new SOR_ParameterNotSupportedException("SOF_hash:hash alg is not support,please set hashAlg for session");
        }
    }

    public String execute(String ... params) throws Exception {
        this.nullPointerIntercept(params);
        String originData = params[0];
        int hashInitId = this.hashInit(this.session);
        this.hashUpdate(this.session, hashInitId, originData);
        HashFinalResponse hashFinalResponse = this.hashFinal(this.session, hashInitId);
        return Base64Utils.encode(hashFinalResponse.getHashValue().getOctets());
    }

    private int hashInit(Session session) throws Exception {
        PublicKey publicKey = CertUtils.getPublicKey(session.getSignCert());
        HashInitRequest hashInitRequest = new HashInitRequest(session.getHashAlg(), SubjectPublicKeyInfo.getInstance(publicKey.getEncoded()), session.getSignID());
        ASN1Sequence sequence = session.getSocketFactory().processing(session.getSocketFd(), hashInitRequest);
        if (sequence == null) {
            throw new ServiceException("hashInit : response is null");
        }
        HashInitResponse hashInitResponse = new HashInitResponse(sequence.getObjectAt(2));
        if (hashInitResponse == null || !hashInitResponse.isSuccess()) {
            throw new ServiceException("hashInit : service internal error");
        }
        return hashInitResponse.getHashId().getValue().intValue();
    }

    private void hashUpdate(Session session, int hashId, String originData) throws Exception {
        HashUpdateRequest hashUpdateRequest = new HashUpdateRequest(hashId, session.getHashAlg(), originData.getBytes());
        ASN1Sequence sequence = session.getSocketFactory().processing(session.getSocketFd(), hashUpdateRequest);
        if (sequence == null) {
            throw new ServiceException("hashUpdate : response is null");
        }
        HashUpdateResponse hashUpdateResponse = new HashUpdateResponse(sequence.getObjectAt(2));
        if (hashUpdateResponse == null || !hashUpdateResponse.isSuccess()) {
            throw new ServiceException("hashUpdate : service internal error");
        }
    }

    private HashFinalResponse hashFinal(Session session, int hashId) throws Exception {
        HashFinalRequest hashFinalRequest = new HashFinalRequest(hashId, session.getHashAlg());
        ASN1Sequence sequence = session.getSocketFactory().processing(session.getSocketFd(), hashFinalRequest);
        if (sequence == null) {
            throw new ServiceException("hashFinal : response is null");
        }
        HashFinalResponse hashFinalResponse = new HashFinalResponse(sequence.getObjectAt(2));
        if (hashFinalResponse == null || !hashFinalResponse.isSuccess()) {
            throw new ServiceException("hashFinal : service internal error");
        }
        return hashFinalResponse;
    }
}

