/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.api.random;

import com.xdja.svs.Session;
import com.xdja.svs.api.BaseExternalApi;
import com.xdja.svs.execption.SOR_ParameterNotSupportedException;
import com.xdja.svs.execption.ServiceException;
import com.xdja.svs.protocol.random.RandomRequest;
import com.xdja.svs.protocol.random.RandomResponse;
import com.xdja.svs.utils.Base64Utils;
import org.bouncycastle.asn1.ASN1Sequence;

public class ApiGenRandom
extends BaseExternalApi<Short, String> {
    Session session;
    int minSeed = 1;
    int maxSeed = MAX_ENC_BUFFER;

    public ApiGenRandom(Session session) {
        this.session = session;
    }

    public String execute(Short ... shorts) throws Exception {
        short seed = shorts[0];
        if (seed < this.minSeed || seed > this.maxSeed) {
            throw new SOR_ParameterNotSupportedException("the seed of random is not support");
        }
        ASN1Sequence sequence = this.session.getSocketFactory().processing(this.session.getSocketFd(), new RandomRequest(seed));
        if (sequence == null) {
            throw new ServiceException("genRandom : response is null");
        }
        RandomResponse randomResponse = new RandomResponse(sequence.getObjectAt(2));
        if (!randomResponse.isSuccess()) {
            throw new ServiceException("genRandom: service internal error");
        }
        return Base64Utils.encode(randomResponse.getData().getOctets());
    }
}

