/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.api.session;

import com.xdja.svs.Session;
import com.xdja.svs.api.BaseExternalApi;
import com.xdja.svs.common.Log;
import com.xdja.svs.config.ApplicationConfig;
import com.xdja.svs.config.ConfigManager;
import com.xdja.svs.execption.ApiException;
import com.xdja.svs.execption.SOR_InitException;
import com.xdja.svs.socket.SocketFactory;
import com.xdja.svs.utils.ApiUtils;
import com.xdja.svs.utils.EmptyUtils;
import java.net.Socket;

public class SessionApi
extends BaseExternalApi<String, Session> {
    public Session execute(String ... params) throws ApiException {
        this.nullPointerIntercept(params);
        String policyName = params[0];
        ApplicationConfig applicationConfig = ConfigManager.getConfigItem(policyName);
        if (applicationConfig == null || EmptyUtils.isEmpty(applicationConfig.getServerIp()) || EmptyUtils.isEmpty(applicationConfig.getPassWd())) {
            throw new SOR_InitException("SOF_getInstance : not found app's config , check the value of param");
        }
        if (!ApiUtils.isNumeric(applicationConfig.getServerPort() + "") || applicationConfig.getServerPort() <= 0 || applicationConfig.getServerPort() > MAX_PORT_NUM) {
            throw new SOR_InitException("SOF_getInstance : server port incorrect");
        }
        try {
            SocketFactory socketFactory = new SocketFactory(applicationConfig.getServerIp(), applicationConfig.getServerPort(), applicationConfig.getReadTimeOut(), applicationConfig.getTimeOut());
            Socket socket = socketFactory.getSocket();
            if (socket == null) {
                Log.print("socket is null");
                throw new SOR_InitException("SOF_getInstance : socket is null");
            }
            return new Session(applicationConfig, socketFactory);
        }
        catch (Exception e) {
            Log.print("Exception ------" + e.getMessage());
            throw new SOR_InitException("SOF_getInstance : socket connection error, check ip,port " + e.getMessage());
        }
    }
}

