/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.api.signdata;

import com.xdja.svs.Session;
import com.xdja.svs.alg.SignAlg;
import com.xdja.svs.api.BaseSignDataApi;
import com.xdja.svs.execption.SOR_ParameterNotSupportedException;
import com.xdja.svs.execption.ServiceException;
import com.xdja.svs.protocol.signdata.response.SignDataFinalResponse;
import com.xdja.svs.utils.Base64Utils;
import com.xdja.svs.utils.CertUtils;
import com.xdja.svs.utils.EmptyUtils;

public class ApiSignData
extends BaseSignDataApi {
    Session session;

    public ApiSignData(Session session) throws Exception {
        this.session = session;
        if (EmptyUtils.isEmpty(session.getAppName())) {
            throw new SOR_ParameterNotSupportedException("SOF_signData:appName is null");
        }
        if (!SignAlg.matchSignAlg(session.getSignAlg())) {
            throw new SOR_ParameterNotSupportedException("SOF_signData:sign alg is not support,please set signAlg for session");
        }
        boolean sm2Cert = CertUtils.isSm2(session.getSignCert());
        boolean sm2Alg = SignAlg.matchSm2Alg(session.getSignAlg());
        if (sm2Cert) {
            if (!sm2Alg) {
                throw new SOR_ParameterNotSupportedException("SOF_signData: sign alg and cert do not match, cert is sm2,sign alg is not sm2");
            }
        } else if (sm2Alg) {
            throw new SOR_ParameterNotSupportedException("SOF_signData: sign alg and cert do not match, cert is rsa,sign alg is not rsa");
        }
    }

    public String execute(byte[] ... bytes) throws Exception {
        this.nullPointerIntercept((Param[])bytes);
        byte[] originText = bytes[0];
        if (originText.length > MAX_ENC_BUFFER) {
            return Base64Utils.encode(this.signedDataMulti(this.session, originText));
        }
        return Base64Utils.encode(this.singleSignedData(this.session, originText));
    }

    protected byte[] signedDataMulti(Session session, byte[] originData) throws Exception {
        int totalLength = originData.length;
        byte[] hash = new byte[32];
        int loop = 0;
        while (true) {
            byte[] inDataTmp;
            if (totalLength >= 4096) {
                inDataTmp = new byte[4096];
                System.arraycopy(originData, loop * 4096, inDataTmp, 0, 4096);
            } else {
                inDataTmp = new byte[totalLength];
                System.arraycopy(originData, loop * 4096, inDataTmp, 0, totalLength);
            }
            if (loop == 0) {
                this.signedDataInit(session, inDataTmp);
            } else {
                this.signedDataUpdate(session, inDataTmp, hash);
            }
            if (totalLength <= 4096) break;
            ++loop;
            totalLength -= 4096;
        }
        SignDataFinalResponse signDataFinalResponse = this.signedDataFinal(session, hash);
        if (signDataFinalResponse == null || !signDataFinalResponse.isSuccess()) {
            throw new ServiceException("SOF_signData : final--- service internal error");
        }
        return signDataFinalResponse.getSignature().getOctets();
    }
}

