/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.api.signdata;

import com.xdja.svs.ErrorBundle;
import com.xdja.svs.Session;
import com.xdja.svs.alg.SignAlg;
import com.xdja.svs.api.BaseVerifySignDataApi;
import com.xdja.svs.execption.ApiException;
import com.xdja.svs.execption.SOR_ParameterNotSupportedException;
import com.xdja.svs.execption.ServiceException;
import com.xdja.svs.protocol.signdata.request.VerifySignedDataRequest;
import com.xdja.svs.protocol.signdata.response.VerifySignDataInitResponse;
import com.xdja.svs.protocol.signdata.response.VerifySignDataUpdateResponse;
import com.xdja.svs.protocol.signdata.response.VerifySignedDataResponse;
import com.xdja.svs.utils.ApiUtils;
import com.xdja.svs.utils.Base64Utils;
import com.xdja.svs.utils.CertUtils;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Sequence;

public class ApiVerifySignedData
extends BaseVerifySignDataApi {
    int paramLength = 3;
    Session session;

    public ApiVerifySignedData(Session session) throws SOR_ParameterNotSupportedException {
        this.session = session;
        if (!SignAlg.matchSignAlg(session.getSignAlg())) {
            throw new SOR_ParameterNotSupportedException("SOF_verifySignedData:sign alg is not support,please set signAlg for session");
        }
    }

    public Boolean execute(String ... params) throws Exception {
        this.nullPointerIntercept(params);
        if (params.length != this.paramLength) {
            throw new SOR_ParameterNotSupportedException("SOF_verifySignedData: the number of params is incorrect");
        }
        String base64Cert = params[0];
        String originData = params[1];
        String signedData = params[2];
        if (!(ApiUtils.isBase64(base64Cert) && ApiUtils.isBase64(signedData) && ApiUtils.verifyLevel(this.session.getVerifyLevel()))) {
            throw new SOR_ParameterNotSupportedException("SOF_verifySignedData: ensure certificate or signedData has been base64 ");
        }
        byte[] certArray = Base64Utils.decode(base64Cert);
        X509Certificate certificate = CertUtils.convert2Certificate(certArray);
        ApiUtils.checkPubKeyAlg(this.session.getSignAlg(), certificate);
        long originDataLength = originData.length();
        if (originDataLength > (long)MAX_ENC_BUFFER) {
            return this.verifySignedDataMulti(this.session, certificate, originData, signedData);
        }
        return this.verifySignedData(this.session, certificate, originData, signedData);
    }

    protected boolean verifySignedDataMulti(Session sof, X509Certificate certificate, String inData, String signature) throws Exception {
        int totalLength = inData.getBytes().length;
        int loop = 0;
        while (true) {
            if (totalLength >= MAX_ENC_BUFFER) {
                this.buffer = new byte[MAX_ENC_BUFFER];
                System.arraycopy(inData.getBytes(), loop * MAX_ENC_BUFFER, this.buffer, 0, MAX_ENC_BUFFER);
            } else {
                this.buffer = new byte[totalLength];
                System.arraycopy(inData.getBytes(), loop * MAX_ENC_BUFFER, this.buffer, 0, totalLength);
            }
            if (loop == 0) {
                VerifySignDataInitResponse verifySignDataInitResponse = this.verifySignedDataInit(sof, certificate, this.buffer);
                if (verifySignDataInitResponse == null || !verifySignDataInitResponse.isSuccess()) {
                    throw new ServiceException("SOF_verifySignedData : init--- service internal error");
                }
            } else {
                VerifySignDataUpdateResponse verifySignDataUpdateResponse = this.verifySignedDataUpdate(sof, this.buffer, this.hash);
                if (verifySignDataUpdateResponse == null || !verifySignDataUpdateResponse.isSuccess()) {
                    throw new ServiceException("SOF_verifySignedData : update--- service internal error");
                }
            }
            if (totalLength <= MAX_ENC_BUFFER) break;
            ++loop;
            totalLength -= MAX_ENC_BUFFER;
        }
        VerifySignedDataResponse verifySignDataFinalResponse = this.verifySignedDataFinal(sof, certificate, this.hash, signature);
        return this.parseResponse(verifySignDataFinalResponse);
    }

    protected boolean verifySignedData(Session session, X509Certificate x509Certificate, String inData, String signature) throws Exception {
        byte[] originSign = Base64Utils.decode(signature);
        ASN1Sequence sequence = session.getSocketFactory().processing(session.getSocketFd(), new VerifySignedDataRequest(session, x509Certificate, inData.getBytes(), originSign));
        if (sequence == null) {
            throw new ServiceException("verifySignedData : response is null");
        }
        VerifySignedDataResponse verifySignedDataResponse = new VerifySignedDataResponse(sequence.getObjectAt(2));
        return this.parseResponse(verifySignedDataResponse);
    }

    private boolean parseResponse(VerifySignedDataResponse response) throws ApiException {
        if (response == null) {
            throw new ServiceException("verifySignedData : service internal error");
        }
        if (!response.isSuccess()) {
            ErrorBundle.throwApiException(response.getRespValue());
        }
        return true;
    }
}

