/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.api.signfile;

import com.xdja.svs.Session;
import com.xdja.svs.alg.SignAlg;
import com.xdja.svs.api.BaseSignDataApi;
import com.xdja.svs.execption.SOR_ParameterNotSupportedException;
import com.xdja.svs.execption.SOR_ReadFileException;
import com.xdja.svs.execption.ServiceException;
import com.xdja.svs.protocol.signdata.response.SignDataFinalResponse;
import com.xdja.svs.utils.Base64Utils;
import com.xdja.svs.utils.EmptyUtils;
import com.xdja.svs.utils.FileUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;

public class ApiSignFile
extends BaseSignDataApi {
    Session session;
    String filePath;

    public ApiSignFile(Session session, String filePath) throws SOR_ParameterNotSupportedException {
        if (EmptyUtils.isEmpty(session.getAppName())) {
            throw new SOR_ParameterNotSupportedException(" app name must not be null");
        }
        if (!SignAlg.matchSignAlg(session.getSignAlg())) {
            throw new SOR_ParameterNotSupportedException("call the method of to set SignAlg(session obj)");
        }
        if (EmptyUtils.isEmpty(filePath)) {
            throw new SOR_ParameterNotSupportedException(" file path can not be null");
        }
        this.session = session;
        this.filePath = filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(byte[] ... bytes) throws Exception {
        File distFile = new File(this.filePath);
        if (!distFile.exists()) {
            throw new SOR_ReadFileException("this file can not read or file is not exist");
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(distFile));
        try {
            while (true) {
                this.readLength = bufferedInputStream.read(this.buffer, 0, this.buffer.length);
                if (this.readLength == -1) break;
                if (this.packNum == 0) {
                    this.signedDataInit(this.session, this.buffer);
                } else {
                    this.signedDataUpdate(this.session, this.buffer, this.hash);
                }
                ++this.packNum;
            }
            SignDataFinalResponse signDataFinalResponse = this.signedDataFinal(this.session, this.hash);
            if (signDataFinalResponse == null || !signDataFinalResponse.isSuccess()) {
                throw new ServiceException("SOF_signData : final--- service internal error");
            }
            String string = Base64Utils.encode(signDataFinalResponse.getSignature().getOctets());
            return string;
        }
        finally {
            FileUtils.close(bufferedInputStream);
        }
    }
}

