/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.api.signfile;

import com.xdja.svs.ErrorBundle;
import com.xdja.svs.Session;
import com.xdja.svs.alg.SignAlg;
import com.xdja.svs.api.BaseVerifySignDataApi;
import com.xdja.svs.execption.SOR_ParameterNotSupportedException;
import com.xdja.svs.execption.SOR_ReadFileException;
import com.xdja.svs.execption.ServiceException;
import com.xdja.svs.protocol.signdata.response.VerifySignDataInitResponse;
import com.xdja.svs.protocol.signdata.response.VerifySignDataUpdateResponse;
import com.xdja.svs.protocol.signdata.response.VerifySignedDataResponse;
import com.xdja.svs.utils.ApiUtils;
import com.xdja.svs.utils.Base64Utils;
import com.xdja.svs.utils.CertUtils;
import com.xdja.svs.utils.FileUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.cert.X509Certificate;

public class ApiVerifySignedFile
extends BaseVerifySignDataApi {
    int paramLength = 3;
    Session session;

    public ApiVerifySignedFile(Session session) throws SOR_ParameterNotSupportedException {
        this.session = session;
        if (!SignAlg.matchSignAlg(session.getSignAlg())) {
            throw new SOR_ParameterNotSupportedException("SOF_verifySignedFile:sign alg is not support,please set signAlg for session");
        }
    }

    public Boolean execute(String ... params) throws Exception {
        Boolean bl;
        this.nullPointerIntercept(params);
        if (params.length != this.paramLength) {
            throw new SOR_ParameterNotSupportedException("SOF_verifySignedFile: the number of params is incorrect");
        }
        String encodeCert = params[0];
        String filePath = params[1];
        String signature = params[2];
        if (!ApiUtils.isBase64(encodeCert) || !ApiUtils.isBase64(signature)) {
            throw new SOR_ParameterNotSupportedException("SOF_verifySignedFile: ensure certificate or signedData has been base64 ");
        }
        byte[] certArray = Base64Utils.decode(encodeCert);
        X509Certificate certificate = CertUtils.convert2Certificate(certArray);
        ApiUtils.checkPubKeyAlg(this.session.getSignAlg(), certificate);
        File disFile = new File(filePath);
        if (!disFile.exists()) {
            throw new SOR_ReadFileException("this file can not read or file is not exist");
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            VerifySignedDataResponse verifySignDataFinalResponse;
            int loop = 0;
            bufferedInputStream = new BufferedInputStream(new FileInputStream(disFile));
            do {
                this.readLength = bufferedInputStream.read(this.buffer, 0, this.buffer.length);
                if (this.readLength == -1) break;
                if (loop == 0) {
                    VerifySignDataInitResponse verifySignDataInitResponse = this.verifySignedDataInit(this.session, certificate, this.buffer);
                    if (verifySignDataInitResponse == null || !verifySignDataInitResponse.isSuccess()) {
                        throw new ServiceException("SOF_verifySignedFile : init--- service internal error");
                    }
                } else {
                    VerifySignDataUpdateResponse verifySignDataUpdateResponse = this.verifySignedDataUpdate(this.session, this.buffer, this.hash);
                    if (verifySignDataUpdateResponse == null || !verifySignDataUpdateResponse.isSuccess()) {
                        throw new ServiceException("SOF_verifySignedFile : update--- service internal error");
                    }
                }
                ++loop;
            } while (this.readLength >= 0);
            if ((verifySignDataFinalResponse = this.verifySignedDataFinal(this.session, certificate, this.hash, signature)) == null) {
                throw new ServiceException("SOF_verifySignedFile : final--- service internal error response is null");
            }
            if (!verifySignDataFinalResponse.isSuccess()) {
                ErrorBundle.throwApiException(verifySignDataFinalResponse.getRespValue());
            }
            bl = true;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                FileUtils.close(bufferedInputStream);
                throw throwable;
            }
        }
        FileUtils.close(bufferedInputStream);
        return bl;
    }
}

