/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.api.signmsg;

import com.xdja.svs.api.BaseExternalApi;
import com.xdja.svs.execption.SOR_MessageEncodeException;
import com.xdja.svs.execption.SOR_ParameterNotSupportedException;
import com.xdja.svs.gmt.GMOid;
import com.xdja.svs.gmt.Sm2SignedData;
import com.xdja.svs.gmt.Sm2SignerInfo;
import com.xdja.svs.utils.Base64Utils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerInfo;

public class ApiGetInfoFromSignedMessage
extends BaseExternalApi<String, byte[]> {
    private static final int ORIGIN = 1;
    private static final int SIGN_CERT = 2;
    private static final int SIGN_VALUE = 3;

    public byte[] execute(String ... params) throws Exception {
        this.nullPointerIntercept(params);
        String signedMessage = params[0];
        this.checkBase64(params[0]);
        int type = Integer.parseInt(params[1]);
        if (type > 3 || type < 1) {
            throw new SOR_ParameterNotSupportedException("the range of type is [1,3]");
        }
        byte[] realMessage = Base64Utils.decode(signedMessage);
        ContentInfo contentInfo = ContentInfo.getInstance(realMessage);
        if (contentInfo == null) {
            throw new SOR_MessageEncodeException("ApiGetInfoFromSignedMessage:signMessage is unsupported,check the value of signMessage");
        }
        ASN1Encodable realSignData = contentInfo.getContent();
        if (!contentInfo.getContentType().getId().equals(GMOid.signedData.getId())) {
            SignedData signedData = SignedData.getInstance(realSignData);
            if (type == 1) {
                return DEROctetString.getInstance(signedData.getEncapContentInfo().getContent()).getOctets();
            }
            if (type == 2) {
                return signedData.getCertificates().getObjectAt(0).toASN1Primitive().getEncoded();
            }
            SignerInfo signerInfo = SignerInfo.getInstance(signedData.getSignerInfos().getObjectAt(0));
            return signerInfo.getEncryptedDigest().getOctets();
        }
        Sm2SignedData gmt0010SignedData = Sm2SignedData.getInstance(realSignData);
        if (type == 1) {
            return DEROctetString.getInstance(gmt0010SignedData.getGmt0010ContentInfo().getContent()).getOctets();
        }
        if (type == 2) {
            return gmt0010SignedData.getCertificates().getObjectAt(0).toASN1Primitive().getEncoded();
        }
        return Sm2SignerInfo.getInstance(gmt0010SignedData.getSignedInfos().getObjectAt(0)).getEncryptedDigest().getOctets();
    }
}

