/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.api.signmsg;

import com.xdja.svs.Session;
import com.xdja.svs.alg.SignAlg;
import com.xdja.svs.api.BaseExternalApi;
import com.xdja.svs.execption.SOR_ParameterNotSupportedException;
import com.xdja.svs.execption.ServiceException;
import com.xdja.svs.protocol.signmsg.request.SignMessageRequest;
import com.xdja.svs.protocol.signmsg.response.SignMessageResponse;
import com.xdja.svs.utils.Base64Utils;
import com.xdja.svs.utils.CertUtils;
import com.xdja.svs.utils.EmptyUtils;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Sequence;

public class ApiSignMessage
extends BaseExternalApi<byte[], String> {
    Session session;

    public ApiSignMessage(Session session) throws SOR_ParameterNotSupportedException {
        this.session = session;
        if (EmptyUtils.isEmpty(session.getAppName())) {
            throw new SOR_ParameterNotSupportedException("SOF_SignMessage:appName is null");
        }
        X509Certificate signCert = session.getSignCert();
        if (signCert == null) {
            throw new SOR_ParameterNotSupportedException("SOF_SignMessage:sign cert is not exist");
        }
        if (!SignAlg.matchSignAlg(session.getSignAlg())) {
            throw new SOR_ParameterNotSupportedException("SOF_SignMessage:sign alg is not support,please set signAlg for session");
        }
        boolean sm2Cert = CertUtils.isSm2(session.getSignCert());
        boolean sm2Alg = SignAlg.matchSm2Alg(session.getSignAlg());
        if (sm2Cert) {
            if (!sm2Alg) {
                throw new SOR_ParameterNotSupportedException("SOF_SignMessage: sign alg and cert do not match, cert is sm2,sign alg is not sm2");
            }
        } else if (sm2Alg) {
            throw new SOR_ParameterNotSupportedException("SOF_SignMessage: sign alg and cert do not match, cert is rsa,sign alg is not rsa");
        }
    }

    public String execute(byte[] ... bytes) throws Exception {
        byte[] originData = bytes[0];
        if (originData == null || originData.length <= 0 || originData.length > MAX_ENC_BUFFER) {
            throw new SOR_ParameterNotSupportedException("SOF_SignMessage : param is not support ,check the value of params , originData.length can not greater than 4096");
        }
        return this.signMessage(this.session, originData);
    }

    private String signMessage(Session session, byte[] inData) throws Exception {
        SignMessageRequest signMessageRequest = new SignMessageRequest(session, inData, true, true, false, false);
        ASN1Sequence sequence = session.getSocketFactory().processing(session.getSocketFd(), signMessageRequest);
        if (sequence == null) {
            throw new ServiceException("signMessage : response is null");
        }
        SignMessageResponse signMessageResponse = new SignMessageResponse(sequence.getObjectAt(2));
        if (signMessageResponse == null || !signMessageResponse.isSuccess()) {
            throw new ServiceException("signMessage : service internal error");
        }
        return Base64Utils.encode(signMessageResponse.getSignedMessage().getOctets());
    }
}

