/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.api.signmsg;

import com.xdja.svs.Session;
import com.xdja.svs.alg.SignAlg;
import com.xdja.svs.api.BaseExternalApi;
import com.xdja.svs.execption.SOR_ParameterNotSupportedException;
import com.xdja.svs.execption.ServiceException;
import com.xdja.svs.protocol.signmsg.request.SignMessageFinalRequest;
import com.xdja.svs.protocol.signmsg.request.SignMessageInitRequest;
import com.xdja.svs.protocol.signmsg.request.SignMessageUpdateRequest;
import com.xdja.svs.protocol.signmsg.response.SignMessageFinalResponse;
import com.xdja.svs.protocol.signmsg.response.SignMessageInitResponse;
import com.xdja.svs.protocol.signmsg.response.SignMessageUpdateResponse;
import com.xdja.svs.utils.Base64Utils;
import com.xdja.svs.utils.CertUtils;
import org.bouncycastle.asn1.ASN1Sequence;

public class ApiSignMessageDetach
extends BaseExternalApi<byte[], String> {
    Session session;

    public ApiSignMessageDetach(Session session) throws SOR_ParameterNotSupportedException {
        this.session = session;
        if (!SignAlg.matchSignAlg(session.getSignAlg())) {
            throw new SOR_ParameterNotSupportedException("SOF_signMessageDetach:sign alg is not support,please set signAlg for session");
        }
        boolean sm2Cert = CertUtils.isSm2(session.getSignCert());
        boolean sm2Alg = SignAlg.matchSm2Alg(session.getSignAlg());
        if (sm2Cert) {
            if (!sm2Alg) {
                throw new SOR_ParameterNotSupportedException("SOF_signMessageDetach: sign alg and cert do not match, cert is sm2,sign alg is not sm2");
            }
        } else if (sm2Alg) {
            throw new SOR_ParameterNotSupportedException("SOF_signMessageDetach: sign alg and cert do not match, cert is rsa,sign alg is not rsa");
        }
    }

    public String execute(byte[] ... bytes) throws Exception {
        byte[] content = bytes[0];
        if (content == null || content.length <= 0) {
            throw new SOR_ParameterNotSupportedException("SOF_signMessageDetach:param is not support");
        }
        return Base64Utils.encode(this.signedMessageDetach(this.session, content));
    }

    public byte[] signedMessageDetach(Session session, byte[] inData) throws Exception {
        byte[] hash = new byte[32];
        int totalLength = inData.length;
        int position = 0;
        while (true) {
            byte[] inDataTmp;
            if (totalLength >= MAX_ENC_BUFFER) {
                inDataTmp = new byte[MAX_ENC_BUFFER];
                System.arraycopy(inData, position * MAX_ENC_BUFFER, inDataTmp, 0, MAX_ENC_BUFFER);
            } else {
                inDataTmp = new byte[totalLength];
                System.arraycopy(inData, position * MAX_ENC_BUFFER, inDataTmp, 0, totalLength);
            }
            if (position == 0) {
                this.signedMessageInit(session, inDataTmp);
            } else {
                this.signedMessageUpdate(session, inDataTmp, hash);
            }
            if (totalLength <= MAX_ENC_BUFFER) break;
            ++position;
            totalLength -= MAX_ENC_BUFFER;
        }
        SignMessageFinalResponse signMessageFinalResponse = this.signedMessageFinal(session, hash);
        return signMessageFinalResponse.getSignature().getOctets();
    }

    private void signedMessageInit(Session session, byte[] inData) throws Exception {
        SignMessageInitRequest signMessageInitRequest = new SignMessageInitRequest(session, inData);
        ASN1Sequence sequence = session.getSocketFactory().processing(session.getSocketFd(), signMessageInitRequest);
        if (sequence == null) {
            throw new ServiceException("SOF_signMessageDetach init : response is null");
        }
        SignMessageInitResponse signMessageInitResponse = new SignMessageInitResponse(sequence.getObjectAt(2));
        if (signMessageInitResponse == null || !signMessageInitResponse.isSuccess()) {
            throw new ServiceException("SOF_signMessageDetach init: service internal error");
        }
    }

    private void signedMessageUpdate(Session session, byte[] inData, byte[] hash) throws Exception {
        SignMessageUpdateRequest signMessageUpdateRequest = new SignMessageUpdateRequest(session.getSignAlg(), hash, inData);
        ASN1Sequence sequence = session.getSocketFactory().processing(session.getSocketFd(), signMessageUpdateRequest);
        if (sequence == null) {
            throw new ServiceException("SOF_signMessageDetach Update : response is null");
        }
        SignMessageUpdateResponse signMessageUpdateResponse = new SignMessageUpdateResponse(sequence.getObjectAt(2));
        if (signMessageUpdateResponse == null || !signMessageUpdateResponse.isSuccess()) {
            throw new ServiceException("SOF_signMessageDetach Update : service internal error");
        }
    }

    private SignMessageFinalResponse signedMessageFinal(Session session, byte[] hash) throws Exception {
        SignMessageFinalRequest signMessageFinalRequest = new SignMessageFinalRequest(session, hash);
        ASN1Sequence sequence = session.getSocketFactory().processing(session.getSocketFd(), signMessageFinalRequest);
        if (sequence == null) {
            throw new ServiceException("SOF_signMessageDetach Final : response is null");
        }
        SignMessageFinalResponse signMessageFinalResponse = new SignMessageFinalResponse(sequence.getObjectAt(2));
        if (signMessageFinalResponse == null || !signMessageFinalResponse.isSuccess()) {
            throw new ServiceException("SOF_signMessageDetach Final : service internal error");
        }
        return signMessageFinalResponse;
    }
}

