/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.api.signmsg;

import com.xdja.svs.ErrorBundle;
import com.xdja.svs.Session;
import com.xdja.svs.api.BaseExternalApi;
import com.xdja.svs.execption.ApiException;
import com.xdja.svs.execption.SOR_MessageEncodeException;
import com.xdja.svs.execption.SOR_ParameterNotSupportedException;
import com.xdja.svs.execption.SOR_VerifySignDataException;
import com.xdja.svs.execption.ServiceException;
import com.xdja.svs.gmt.GMOid;
import com.xdja.svs.gmt.Sm2SignedData;
import com.xdja.svs.protocol.signmsg.request.VerifySignedMessageRequest;
import com.xdja.svs.protocol.signmsg.response.VerifySignedMessageResponse;
import com.xdja.svs.socket.Tlv;
import com.xdja.svs.socket.TlvTools;
import com.xdja.svs.utils.ApiUtils;
import com.xdja.svs.utils.Base64Utils;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;

public class ApiVerifySignedMessage
extends BaseExternalApi<String, Boolean> {
    Session session;

    public ApiVerifySignedMessage(Session session) throws SOR_ParameterNotSupportedException {
        this.session = session;
        if (!ApiUtils.verifyLevel(session.getVerifyLevel())) {
            throw new SOR_ParameterNotSupportedException("SOF_verifySignedMessage:verifyLevel 's value is not support");
        }
    }

    public Boolean execute(String ... params) throws Exception {
        byte[] original;
        this.nullPointerIntercept(params);
        this.checkBase64(params[0]);
        byte[] signValue = Base64Utils.decode(params[0]);
        ContentInfo contentInfo = ContentInfo.getInstance(signValue);
        if (contentInfo == null) {
            throw new SOR_MessageEncodeException("SOF_verifySignedMessage:signValue is unsupported,check the value of signValue");
        }
        try {
            if (GMOid.signedData.equals(contentInfo.getContentType().getId())) {
                Sm2SignedData gmt0010SignedData = Sm2SignedData.getInstance(contentInfo.getContent());
                original = gmt0010SignedData.getGmt0010ContentInfo().getContent().toASN1Primitive().getEncoded();
            } else {
                SignedData signedData = SignedData.getInstance(contentInfo.getContent());
                original = signedData.getEncapContentInfo().getContent().toASN1Primitive().getEncoded();
            }
        }
        catch (Exception e) {
            throw new SOR_ParameterNotSupportedException("SOF_verifySignedMessage: parse content info error, content may be is null");
        }
        if (original == null) {
            throw new SOR_VerifySignDataException("SOF_verifySignedMessage: convert sign data error ");
        }
        String hexString = TlvTools.bytesToHex(original);
        List<Tlv> tlvList = new ArrayList<Tlv>();
        tlvList = TlvTools.unpack(tlvList, hexString);
        byte[] value = tlvList.get(0).getValue();
        VerifySignedMessageRequest verifySignedMessageRequest = new VerifySignedMessageRequest(value.length, value, signValue, this.session.isHashValue(), true, true, false, false);
        ASN1Sequence sequence = this.session.getSocketFactory().processing(this.session.getSocketFd(), verifySignedMessageRequest);
        if (sequence == null) {
            throw new ServiceException("SOF_verifySignedMessage : response is null");
        }
        VerifySignedMessageResponse verifySignedMessageResponse = new VerifySignedMessageResponse(sequence.getObjectAt(2));
        return this.parseResponse(verifySignedMessageResponse);
    }

    private boolean parseResponse(VerifySignedMessageResponse response) throws ApiException {
        if (response == null) {
            throw new ServiceException("SOF_verifySignedMessage : service internal error");
        }
        if (!response.isSuccess()) {
            ApiException exception = ErrorBundle.getException(response.getRespValue());
            if (exception == null) {
                throw new ServiceException("SOF_verifySignedMessage : service internal error");
            }
            throw exception;
        }
        return true;
    }
}

