/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.api.signmsg;

import com.xdja.svs.Session;
import com.xdja.svs.alg.SignAlg;
import com.xdja.svs.api.BaseExternalApi;
import com.xdja.svs.execption.SOR_ParameterNotSupportedException;
import com.xdja.svs.execption.ServiceException;
import com.xdja.svs.gmt.ContentInfoUtils;
import com.xdja.svs.protocol.signmsg.request.VerifySignedMessageFinalRequest;
import com.xdja.svs.protocol.signmsg.request.VerifySignedMessageInitRequest;
import com.xdja.svs.protocol.signmsg.request.VerifySignedMessageUpdateRequest;
import com.xdja.svs.protocol.signmsg.response.VerifySignedMessageFinalResponse;
import com.xdja.svs.protocol.signmsg.response.VerifySignedMessageInitResponse;
import com.xdja.svs.protocol.signmsg.response.VerifySignedMessageUpdateResponse;
import com.xdja.svs.utils.ApiUtils;
import com.xdja.svs.utils.Base64Utils;
import com.xdja.svs.utils.CertUtils;
import com.xdja.svs.utils.EmptyUtils;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Sequence;

public class ApiVerifySignedMessageDetach
extends BaseExternalApi<byte[], Boolean> {
    Session session;
    String signedMessage;

    public ApiVerifySignedMessageDetach(Session session, String signedMessage) throws SOR_ParameterNotSupportedException {
        if (!SignAlg.matchSignAlg(session.getSignAlg())) {
            throw new SOR_ParameterNotSupportedException("SOF_verifySignedMessageDetach:sign alg is not support,please set signAlg for session");
        }
        if (EmptyUtils.isEmpty(signedMessage)) {
            throw new SOR_ParameterNotSupportedException("SOF_verifySignedMessageDetach:signed message is null");
        }
        this.checkBase64(signedMessage);
        this.session = session;
        this.signedMessage = signedMessage;
    }

    public Boolean execute(byte[] ... params) throws Exception {
        this.nullPointerIntercept((Param[])params);
        String plainData = new String(params[0]);
        byte[] signMessage = Base64Utils.decode(this.signedMessage);
        X509Certificate certificate = ContentInfoUtils.parseCert(signMessage);
        PublicKey publicKey = CertUtils.getPublicKey(certificate);
        if (!ApiUtils.checkPubKeyAlg(this.session.getSignAlg(), certificate)) {
            throw new SOR_ParameterNotSupportedException("SOF_verifySignedMessageDetach: pubkey can not match sign alg");
        }
        byte[] originData = plainData.getBytes();
        int originDataLength = originData.length;
        byte[] hash = new byte[32];
        int loop = 0;
        while (true) {
            byte[] inDataTmp;
            if (originDataLength >= 4096) {
                inDataTmp = new byte[4096];
                System.arraycopy(originData, loop * 4096, inDataTmp, 0, 4096);
            } else {
                inDataTmp = new byte[originDataLength];
                System.arraycopy(originData, loop * 4096, inDataTmp, 0, originDataLength);
            }
            if (loop == 0) {
                this.verifySignedMessageInit(this.session, inDataTmp, publicKey);
            } else {
                this.verifySignedMessageUpdate(this.session, inDataTmp, hash);
            }
            if (originDataLength <= 4096) break;
            ++loop;
            originDataLength -= 4096;
        }
        return this.verifySignedMessageFinal(this.session, certificate, hash, signMessage);
    }

    private void verifySignedMessageInit(Session session, byte[] inData, PublicKey publicKey) throws Exception {
        ASN1Sequence sequence = session.getSocketFactory().processing(session.getSocketFd(), new VerifySignedMessageInitRequest(session, inData, publicKey));
        if (sequence == null) {
            throw new ServiceException("SOF_verifySignedMessageDetach---init : response is null");
        }
        VerifySignedMessageInitResponse verifySignedMessageIntResp = new VerifySignedMessageInitResponse(sequence.getObjectAt(2));
        if (verifySignedMessageIntResp == null || !verifySignedMessageIntResp.isSuccess()) {
            throw new ServiceException("SOF_verifySignedMessageDetach---init : service internal error");
        }
    }

    private void verifySignedMessageUpdate(Session session, byte[] inData, byte[] hash) throws Exception {
        ASN1Sequence sequence = session.getSocketFactory().processing(session.getSocketFd(), new VerifySignedMessageUpdateRequest(session.getSignAlg(), hash, inData));
        if (sequence == null) {
            throw new ServiceException("SOF_verifySignedMessageDetach---update : response is null");
        }
        VerifySignedMessageUpdateResponse verifySignDataUpdateResp = new VerifySignedMessageUpdateResponse(sequence.getObjectAt(2));
        if (verifySignDataUpdateResp == null || !verifySignDataUpdateResp.isSuccess()) {
            throw new ServiceException("SOF_verifySignedMessageDetach---update : service internal error");
        }
    }

    public boolean verifySignedMessageFinal(Session session, X509Certificate certificate, byte[] hashValue, byte[] signature) throws Exception {
        VerifySignedMessageFinalRequest verifySignedMessageFinalRequest = new VerifySignedMessageFinalRequest(session, certificate, hashValue, signature);
        ASN1Sequence sequence = session.getSocketFactory().processing(session.getSocketFd(), verifySignedMessageFinalRequest);
        if (sequence == null) {
            throw new ServiceException("SOF_verifySignedMessageDetach---final : response is null");
        }
        VerifySignedMessageFinalResponse verifySignedMessageFinalResponse = new VerifySignedMessageFinalResponse(sequence.getObjectAt(2));
        if (verifySignedMessageFinalResponse == null || !verifySignedMessageFinalResponse.isSuccess()) {
            throw new ServiceException("SOF_verifySignedMessageDetach---final : service internal error");
        }
        return verifySignedMessageFinalResponse.isSuccess();
    }
}

