/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.api.signxml;

import com.xdja.svs.Session;
import com.xdja.svs.api.signdata.ApiSignData;
import com.xdja.svs.execption.SOR_AppNotFoundException;
import com.xdja.svs.execption.SOR_ParameterNotSupportedException;
import com.xdja.svs.execption.SOR_XmlEncodeException;
import com.xdja.svs.utils.ApiUtils;
import com.xdja.svs.utils.EmptyUtils;
import com.xdja.svs.utils.XmlSignedVerifyUtils;
import java.security.cert.X509Certificate;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;

public class ApiSignDataXml
extends ApiSignData {
    Session session;
    String origin;

    public ApiSignDataXml(Session session, String inData) throws Exception {
        super(session);
        this.session = session;
        if (EmptyUtils.isEmpty(session.getAppName())) {
            throw new SOR_AppNotFoundException("app name is null");
        }
        ApiUtils.matchedXmlType(session.getXmlType());
        if (EmptyUtils.isEmpty(inData)) {
            throw new SOR_ParameterNotSupportedException("inData is null");
        }
        this.origin = inData;
    }

    @Override
    public String execute(byte[] ... params) throws Exception {
        this.validateXml(this.origin);
        String signature = super.execute(new byte[][]{this.origin.getBytes()});
        return this.signedXml(this.session, this.origin, signature);
    }

    private void validateXml(String xml) throws SOR_XmlEncodeException {
        try {
            DocumentHelper.parseText(xml);
        }
        catch (DocumentException e) {
            throw new SOR_XmlEncodeException("SignXml: xml syntax error , please check your xml");
        }
    }

    private String signedXml(Session session, String origin, String signature) throws SOR_ParameterNotSupportedException {
        X509Certificate signCert = session.getSignCert();
        long signAlg = session.getSignAlg();
        switch (session.getXmlType()) {
            case 0: {
                return XmlSignedVerifyUtils.packetXMLEnveloping(signCert, origin, signAlg, signature);
            }
            case 1: {
                return XmlSignedVerifyUtils.packetXMLEnveloped(signCert, origin, signAlg, signature);
            }
            case 2: {
                return XmlSignedVerifyUtils.packetXMLDetached(signCert, origin, signAlg, signature);
            }
        }
        throw new UnsupportedOperationException("SOF_signDataXML: can not matched type (session xmlType)");
    }
}

