/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.api.signxml;

import com.xdja.svs.Session;
import com.xdja.svs.api.signdata.ApiVerifySignedData;
import com.xdja.svs.execption.SOR_ParameterNotSupportedException;
import com.xdja.svs.execption.UnsupportedDetachOperationException;
import com.xdja.svs.utils.Base64Utils;
import com.xdja.svs.utils.CertUtils;
import com.xdja.svs.utils.XmlSignUtils;
import java.security.cert.X509Certificate;
import java.util.Map;

public class ApiVerifySignedDataXml
extends ApiVerifySignedData {
    Session session;

    public ApiVerifySignedDataXml(Session session) throws SOR_ParameterNotSupportedException {
        super(session);
        this.session = session;
    }

    @Override
    public Boolean execute(String ... params) throws Exception {
        this.nullPointerIntercept(params);
        String xmlSignedData = params[0];
        Map<Integer, String> result = XmlSignUtils.unMarshalXML(xmlSignedData);
        if (result.isEmpty()) {
            return false;
        }
        String type = result.get(1000);
        if (type.equals("2")) {
            throw new UnsupportedDetachOperationException("SOF_verifySignedDataXML: XML_DETACH can not supported");
        }
        String cert = result.get(4);
        String signatureValue = result.get(3);
        String origin = result.get(1);
        X509Certificate certificate = CertUtils.convert2Certificate(Base64Utils.decode(cert));
        if (origin.length() > MAX_ENC_BUFFER) {
            return this.verifySignedDataMulti(this.session, certificate, origin, signatureValue);
        }
        return this.verifySignedData(this.session, certificate, origin, signatureValue);
    }
}

