/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.api.timestamp;

import com.xdja.pki.gmssl.crypto.utils.GMSSLSHA1DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSHA256DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import com.xdja.svs.Session;
import com.xdja.svs.alg.SignAlg;
import com.xdja.svs.api.BaseExternalApi;
import com.xdja.svs.execption.SOR_ParameterNotSupportedException;
import com.xdja.svs.utils.Base64Utils;
import org.bouncycastle.tsp.TSPAlgorithms;
import org.bouncycastle.tsp.TimeStampRequestGenerator;

public class ApiCreateTimeStampRequest
extends BaseExternalApi<byte[], String> {
    Session session;

    public ApiCreateTimeStampRequest(Session session) throws SOR_ParameterNotSupportedException {
        this.session = session;
        if (!SignAlg.matchSignAlg(session.getSignAlg())) {
            throw new SOR_ParameterNotSupportedException("SOF_createTimeStampRequest:sign alg is not support,please set signAlg for session");
        }
    }

    public String execute(byte[] ... bytes) throws Exception {
        this.nullPointerIntercept((Param[])bytes);
        byte[] timeRequest = this.buildTimeStampRequest(bytes[0], SignAlg.find(this.session.getSignAlg()));
        return Base64Utils.encode(timeRequest);
    }

    private byte[] buildTimeStampRequest(byte[] inData, SignAlg signMethod) throws Exception {
        TimeStampRequestGenerator timeStampRequest = new TimeStampRequestGenerator();
        timeStampRequest.setCertReq(this.session.isCertReq());
        switch (signMethod) {
            case SM3_SM2: 
            case SM3_RSA: {
                return timeStampRequest.generate(TSPAlgorithms.SM3, GMSSLSM3DigestUtils.digest(inData)).getEncoded();
            }
            case SHA1_RSA: {
                return timeStampRequest.generate(TSPAlgorithms.SHA1, GMSSLSHA1DigestUtils.digest(inData)).getEncoded();
            }
            case SHA256_RSA: {
                return timeStampRequest.generate(TSPAlgorithms.SHA256, GMSSLSHA256DigestUtils.digest(inData)).getEncoded();
            }
        }
        throw new UnsupportedOperationException("SOF_createTimeStampRequest: sign alg is unsupported");
    }
}

