/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.api.timestamp;

import com.xdja.svs.Session;
import com.xdja.svs.alg.SignAlg;
import com.xdja.svs.api.BaseExternalApi;
import com.xdja.svs.execption.SOR_ParameterNotSupportedException;
import com.xdja.svs.execption.ServiceException;
import com.xdja.svs.protocol.timestamp.CreateTimeStampRespRequest;
import com.xdja.svs.protocol.timestamp.CreateTimeStampRespResponse;
import com.xdja.svs.utils.Base64Utils;
import com.xdja.svs.utils.EmptyUtils;
import org.bouncycastle.asn1.ASN1Sequence;

public class ApiCreateTimeStampResponse
extends BaseExternalApi<String, String> {
    Session session;

    public ApiCreateTimeStampResponse(Session session) throws SOR_ParameterNotSupportedException {
        this.session = session;
        if (EmptyUtils.isEmpty(session.getAppName())) {
            throw new SOR_ParameterNotSupportedException("SOF_createTimeStampResponse:appName is null");
        }
        if (!SignAlg.matchSignAlg(session.getSignAlg())) {
            throw new SOR_ParameterNotSupportedException("SOF_createTimeStampResponse:sign alg is not support,please set signAlg for session");
        }
    }

    public String execute(String ... params) throws Exception {
        this.nullPointerIntercept(params);
        this.checkBase64(params[0]);
        byte[] timeStampRequest = Base64Utils.decode(params[0]);
        return this.createTimeStampResponse(this.session, timeStampRequest);
    }

    private String createTimeStampResponse(Session session, byte[] timeStampRequest) throws Exception {
        ASN1Sequence sequence = session.getSocketFactory().processing(session.getSocketFd(), new CreateTimeStampRespRequest(timeStampRequest, session));
        if (sequence == null) {
            throw new ServiceException("SOF_createTimeStampResponse : response is null");
        }
        CreateTimeStampRespResponse createTimeStampRespResponse = new CreateTimeStampRespResponse(sequence.getObjectAt(2));
        if (createTimeStampRespResponse == null || !createTimeStampRespResponse.isSuccess()) {
            throw new ServiceException("SOF_createTimeStampResponse : service internal error");
        }
        return Base64Utils.encode(createTimeStampRespResponse.getTsResp().getOctets());
    }
}

