/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.api.timestamp;

import com.xdja.svs.api.BaseExternalApi;
import com.xdja.svs.execption.ApiException;
import com.xdja.svs.execption.SOR_MessageEncodeException;
import com.xdja.svs.execption.SOR_ParameterNotSupportedException;
import com.xdja.svs.gmt.GMOid;
import com.xdja.svs.gmt.Sm2SignedData;
import com.xdja.svs.gmt.Sm2SignerInfo;
import com.xdja.svs.utils.Base64Utils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.tsp.TSTInfo;
import org.bouncycastle.asn1.tsp.TimeStampResp;

public class ApiGetTimeStampInfo
extends BaseExternalApi<String, String> {
    int timeStampKey = 1;
    int timeStampSignKey = 2;
    int timeStampSignCertKey = 3;

    public String execute(String ... params) throws Exception {
        this.nullPointerIntercept(params);
        String timeStampData = params[0];
        this.checkBase64(timeStampData);
        int xmlType = Integer.parseInt(params[1]);
        if (xmlType != this.timeStampKey && xmlType != this.timeStampSignKey && xmlType != this.timeStampSignCertKey) {
            throw new SOR_ParameterNotSupportedException("the session of XmlType field is not support ");
        }
        Map<Integer, String> result = this.parseTimeStamp(Base64Utils.decode(timeStampData));
        return result.get(xmlType);
    }

    private Map<Integer, String> parseTimeStamp(byte[] asn1OctetString) throws Exception {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        TimeStampResp response = TimeStampResp.getInstance(asn1OctetString);
        if (response == null) {
            throw new SOR_MessageEncodeException("GetTimeStampInfo:  parse timeStamp error");
        }
        int status = response.getStatus().getStatus().intValue();
        if (status == 0) {
            if (response.getTimeStampToken().getContentType().equals(GMOid.signedData)) {
                Sm2SignedData signData = Sm2SignedData.getInstance(response.getTimeStampToken().getContent());
                byte[] tstInfoData = signData.getGmt0010ContentInfo().getContent().getOctets();
                ASN1Sequence asn1Sequence = ASN1Sequence.getInstance(tstInfoData);
                TSTInfo tstInfo = TSTInfo.getInstance(asn1Sequence);
                String time = tstInfo.getGenTime().getDate().toString();
                result.put(this.timeStampKey, time);
                byte[] signValue = Sm2SignerInfo.getInstance(signData.getSignedInfos().getObjectAt(0)).getEncryptedDigest().getOctets();
                result.put(this.timeStampSignKey, Base64Utils.encode(signValue));
                this.wrapCert(result, signData.getCertificates());
            } else if (response.getTimeStampToken().getContentType().equals(PKCSObjectIdentifiers.signedData)) {
                SignedData signedData = SignedData.getInstance(response.getTimeStampToken().getContent());
                ContentInfo contentInfo = signedData.getEncapContentInfo();
                ASN1OctetString content = DEROctetString.getInstance(contentInfo.getContent());
                ASN1Sequence tstInfoSequence = ASN1Sequence.getInstance(content.getOctets());
                TSTInfo tstInfo = TSTInfo.getInstance(tstInfoSequence);
                String time = tstInfo.getGenTime().getDate().toString();
                result.put(this.timeStampKey, time);
                byte[] signValue = SignerInfo.getInstance(signedData.getSignerInfos().getObjectAt(0)).getEncryptedDigest().getOctets();
                result.put(this.timeStampSignKey, Base64Utils.encode(signValue));
                this.wrapCert(result, signedData.getCertificates());
            } else {
                throw new SOR_ParameterNotSupportedException("SOF_getTimeStampInfo: can not matched contentType by oid ");
            }
            return result;
        }
        throw new ApiException("SOF_getTimeStampInfo:TimeStampResp parse exception");
    }

    private void wrapCert(Map<Integer, String> result, ASN1Set certificates) throws IOException {
        if (certificates != null && certificates.size() > 0) {
            byte[] cert = certificates.getObjectAt(0).toASN1Primitive().getEncoded();
            result.put(this.timeStampSignCertKey, Base64Utils.encode(cert));
        } else {
            result.put(this.timeStampSignCertKey, "");
        }
    }
}

