/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.api.timestamp;

import com.xdja.pki.gmssl.crypto.utils.GMSSLSHA1DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSHA256DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import com.xdja.svs.ErrorBundle;
import com.xdja.svs.Session;
import com.xdja.svs.alg.SignAlg;
import com.xdja.svs.api.BaseExternalApi;
import com.xdja.svs.execption.ApiException;
import com.xdja.svs.execption.SOR_MessageEncodeException;
import com.xdja.svs.execption.SOR_ParameterNotSupportedException;
import com.xdja.svs.execption.ServiceException;
import com.xdja.svs.protocol.signmsg.response.VerifyTimeStampResponse;
import com.xdja.svs.protocol.timestamp.VerifyTimeStampRequest;
import com.xdja.svs.utils.ApiUtils;
import com.xdja.svs.utils.Base64Utils;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.tsp.TSTInfo;
import org.bouncycastle.asn1.tsp.TimeStampResp;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.tsp.TSPAlgorithms;
import org.bouncycastle.util.encoders.Hex;

public class ApiVerifyTimeStamp
extends BaseExternalApi<String, Boolean> {
    Session session;

    public ApiVerifyTimeStamp(Session session) throws SOR_ParameterNotSupportedException {
        this.session = session;
        if (!SignAlg.matchRSAAlg(session.getSignAlg()) && !SignAlg.matchSm2Alg(session.getSignAlg())) {
            throw new SOR_ParameterNotSupportedException("SOF_verifyTimeStamp:sign alg is not support,please set signAlg for session");
        }
    }

    public Boolean execute(String ... params) throws Exception {
        byte[] paramContentHash;
        boolean attachCert;
        String originHashString;
        TSTInfo realTSTInfo;
        this.nullPointerIntercept(params);
        ApiUtils.verifyLevel(this.session.getVerifyLevel());
        String paramContent = params[0];
        String timeStampResponse = params[1];
        this.checkBase64(timeStampResponse);
        byte[] param = Base64Utils.decode(timeStampResponse);
        SignedData signedData = this.parseTSP(param);
        try {
            ContentInfo contentInfo = signedData.getEncapContentInfo();
            ASN1OctetString octetString = DEROctetString.getInstance(contentInfo.getContent());
            ASN1Sequence sequence = ASN1Sequence.getInstance(octetString.getOctets());
            realTSTInfo = TSTInfo.getInstance(sequence);
            byte[] originHash = realTSTInfo.getMessageImprint().getHashedMessage();
            originHashString = Hex.toHexString(originHash);
            attachCert = this.useAppSignCert(signedData);
        }
        catch (Exception e) {
            throw new SOR_ParameterNotSupportedException("please check the value of params");
        }
        AlgorithmIdentifier hashAlg = realTSTInfo.getMessageImprint().getHashAlgorithm();
        if (hashAlg.getAlgorithm().getId().equals(TSPAlgorithms.SM3.getId())) {
            paramContentHash = GMSSLSM3DigestUtils.digest(paramContent.getBytes());
        } else if (hashAlg.getAlgorithm().getId().equals(TSPAlgorithms.SHA1.getId())) {
            paramContentHash = GMSSLSHA1DigestUtils.digest(paramContent.getBytes());
        } else if (hashAlg.getAlgorithm().getId().equals(TSPAlgorithms.SHA256.getId())) {
            paramContentHash = GMSSLSHA256DigestUtils.digest(paramContent.getBytes());
        } else {
            throw new SOR_ParameterNotSupportedException("unmatched hash alg");
        }
        if (null == paramContentHash || paramContentHash.length <= 0) {
            throw new SOR_ParameterNotSupportedException("unmatched hash alg");
        }
        String paramContentHashString = Hex.toHexString(paramContentHash);
        if (!paramContentHashString.equals(originHashString)) {
            throw new SOR_ParameterNotSupportedException("origin content 's hash value is not equals param's hash value");
        }
        return this.verifyTimeStamp(this.session, param, attachCert);
    }

    private SignedData parseTSP(byte[] timeStampResponse) throws Exception {
        TimeStampResp response = TimeStampResp.getInstance(timeStampResponse);
        if (response == null) {
            throw new SOR_MessageEncodeException("SOF_verifyTimeStamp:  parse timeStamp error");
        }
        ContentInfo contentInfo = response.getTimeStampToken();
        SignedData signedData = SignedData.getInstance(contentInfo.getContent());
        return signedData;
    }

    private boolean useAppSignCert(SignedData signedData) {
        ASN1Set certs = signedData.getCertificates();
        return certs == null || certs.size() <= 0;
    }

    public boolean verifyTimeStamp(Session session, byte[] timeStampResponse, boolean attachCert) throws Exception {
        VerifyTimeStampRequest verifyTimeStampRequest = new VerifyTimeStampRequest(timeStampResponse, session, attachCert);
        ASN1Sequence sequence = session.getSocketFactory().processing(session.getSocketFd(), verifyTimeStampRequest);
        if (sequence == null) {
            throw new ServiceException("SOF_verifyTimeStamp : response is null");
        }
        VerifyTimeStampResponse verifyTimeStampResponse = new VerifyTimeStampResponse(sequence.getObjectAt(2));
        return this.parseResponse(verifyTimeStampResponse);
    }

    private boolean parseResponse(VerifyTimeStampResponse response) throws ApiException {
        if (response == null) {
            throw new ServiceException("SOF_verifyTimeStamp : service internal error");
        }
        if (!response.isSuccess()) {
            ApiException exception = ErrorBundle.getException(response.getRespValue());
            if (exception == null) {
                throw new ServiceException("SOF_verifyTimeStamp : service internal error");
            }
            throw exception;
        }
        return true;
    }
}

