/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.api.validatecert;

import com.xdja.svs.ErrorBundle;
import com.xdja.svs.Session;
import com.xdja.svs.api.BaseExternalApi;
import com.xdja.svs.execption.ApiException;
import com.xdja.svs.execption.ServiceException;
import com.xdja.svs.protocol.certinfo.ValidateCertRequest;
import com.xdja.svs.protocol.certinfo.ValidateCertResponse;
import com.xdja.svs.utils.Base64Utils;
import com.xdja.svs.utils.CertUtils;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Sequence;

public class ApiValidateCert
extends BaseExternalApi<String, Integer> {
    private static final int CERT_UN_TRUSTED = -1;
    private static final int CERT_INVALID_AF = -2;
    private static final int CERT_REVOKED = -3;
    private static final int CERT_INVALID_BF = -5;
    private static final int UNKNOWN = -6;
    Session session;

    public ApiValidateCert(Session session) {
        this.session = session;
    }

    public Integer execute(String ... params) throws Exception {
        this.nullPointerIntercept(params);
        this.checkBase64(params[0]);
        X509Certificate x509Certificate = CertUtils.convert2Certificate(Base64Utils.decode(params[0]));
        ASN1Sequence sequence = this.session.getSocketFactory().processing(this.session.getSocketFd(), new ValidateCertRequest(x509Certificate, this.session.isOcsp()));
        if (sequence == null) {
            throw new ServiceException("SOF_validateCert : response is null");
        }
        ValidateCertResponse validateCertResponse = new ValidateCertResponse(sequence.getObjectAt(2));
        if (this.session.isOcsp()) {
            if (validateCertResponse.isSuccess()) {
                int stateCode = validateCertResponse.getStateCode();
                switch (stateCode) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return -3;
                    }
                }
                return -6;
            }
            ApiException exception = ErrorBundle.getException(validateCertResponse.getResValue());
            if (exception != null) {
                throw exception;
            }
            throw new ServiceException("SOF_validateCert : service internal error");
        }
        int responseCode = validateCertResponse.getResValue();
        switch (responseCode) {
            case 0: {
                return 1;
            }
            case 0x4000009: {
                return -2;
            }
            case 0x400000A: {
                return -5;
            }
            case 0x400000B: {
                return -3;
            }
            case 0x4000020: {
                return -1;
            }
        }
        return -6;
    }
}

