/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.xdja.svs.common.Log;
import com.xdja.svs.config.ApplicationConfig;
import com.xdja.svs.config.Config;
import com.xdja.svs.execption.SOR_InitException;
import com.xdja.svs.utils.EmptyUtils;
import com.xdja.svs.utils.FileUtils;
import java.io.File;

public class ConfigManager {
    private static Config cacheConfig;

    public static void configInitialization(File file) throws SOR_InitException {
        if (!file.exists()) {
            throw new SOR_InitException("json file is not found");
        }
        try {
            byte[] result = FileUtils.readFile2Byte(file);
            cacheConfig = (Config)JSON.parseObject(result, Config.class, new Feature[0]);
            Log.print("parse json content -----success");
        }
        catch (Exception e) {
            throw new SOR_InitException("parse json file error");
        }
    }

    public static String getCertTrustPath() throws SOR_InitException {
        if (cacheConfig == null) {
            throw new SOR_InitException("cacheConfig has not been initialized, call to configInitialization(file) must be first");
        }
        return cacheConfig.getCertTrustPath();
    }

    public static ApplicationConfig getConfigItem(String policyName) throws SOR_InitException {
        if (EmptyUtils.isEmpty(policyName)) {
            throw new SOR_InitException("param key must be not null,call to configInitialization(file) must be first");
        }
        if (cacheConfig == null || cacheConfig.getApplications() == null || cacheConfig.getApplications().isEmpty()) {
            throw new SOR_InitException("cacheConfig has not been initialized,call to configInitialization(file) must be first");
        }
        return cacheConfig.getApplications().get(policyName);
    }
}

