/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.gmt;

import com.xdja.svs.execption.SOR_DecryptDataException;
import com.xdja.svs.execption.SOR_Pkcs7EncodeException;
import com.xdja.svs.gmt.GMOid;
import com.xdja.svs.gmt.Sm2EncryptedContentInfo;
import com.xdja.svs.gmt.Sm2EnvelopedData;
import com.xdja.svs.gmt.Sm2RecipientInfo;
import com.xdja.svs.gmt.Sm2SignedData;
import com.xdja.svs.utils.Base64Utils;
import com.xdja.svs.utils.CertUtils;
import java.io.IOException;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.EnvelopedData;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientIdentifier;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class ContentInfoUtils {
    public static String packEncryptedData(X509Certificate x509Certificate, byte[] encryptedKey, byte[] cipherData, ASN1OctetString iv, AlgorithmIdentifier encryptModeOid) throws IOException {
        IssuerAndSerialNumber issuerAndSerialNumber = ContentInfoUtils.buildIssuerAndSerialNumber(x509Certificate);
        RecipientIdentifier recipientIdentifier = ContentInfoUtils.buildRecipientIdentifier(issuerAndSerialNumber);
        DEROctetString encryptedKeyValue = new DEROctetString(encryptedKey);
        AlgorithmIdentifier contentEncryptionAlgorithm = new AlgorithmIdentifier(encryptModeOid.getAlgorithm(), iv);
        if (CertUtils.isSm2(x509Certificate)) {
            AlgorithmIdentifier encryptAlgOid = new AlgorithmIdentifier(GMObjectIdentifiers.sm2encrypt);
            KeyTransRecipientInfo keyTransRecipientInfo = ContentInfoUtils.buildKeyTransRecipientInfo(recipientIdentifier, encryptAlgOid, encryptedKeyValue);
            RecipientInfo recipientInfo = ContentInfoUtils.buildRecipientInfo(keyTransRecipientInfo);
            ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
            recipientInfos.add(recipientInfo);
            Sm2EncryptedContentInfo encryptedContentInfo = new Sm2EncryptedContentInfo(new AlgorithmIdentifier(GMOid.encryptedData), contentEncryptionAlgorithm, cipherData, "", "");
            Sm2EnvelopedData envelopedData = new Sm2EnvelopedData(new DERSet(recipientInfos), encryptedContentInfo);
            ContentInfo contentInfo = new ContentInfo(GMOid.envelopedData, envelopedData.toASN1Primitive());
            return Base64Utils.encode(contentInfo.getEncoded());
        }
        AlgorithmIdentifier encryptAlgOid = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption);
        KeyTransRecipientInfo keyTransRecipientInfo = ContentInfoUtils.buildKeyTransRecipientInfo(recipientIdentifier, encryptAlgOid, encryptedKeyValue);
        RecipientInfo recipientInfo = ContentInfoUtils.buildRecipientInfo(keyTransRecipientInfo);
        ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
        recipientInfos.add(recipientInfo);
        EncryptedContentInfo encryptedContentInfo = new EncryptedContentInfo(PKCSObjectIdentifiers.encryptedData, contentEncryptionAlgorithm, new DEROctetString(cipherData));
        EnvelopedData envelopedData = new EnvelopedData(null, (ASN1Set)new DERSet(recipientInfos), encryptedContentInfo, new DERSet());
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.envelopedData, envelopedData.toASN1Primitive());
        return Base64Utils.encode(contentInfo.getEncoded());
    }

    private static IssuerAndSerialNumber buildIssuerAndSerialNumber(X509Certificate x509Certificate) {
        return new IssuerAndSerialNumber(X500Name.getInstance(x509Certificate.getIssuerDN()), x509Certificate.getSerialNumber());
    }

    private static RecipientIdentifier buildRecipientIdentifier(IssuerAndSerialNumber issuerAndSerialNumber) {
        return new RecipientIdentifier(issuerAndSerialNumber);
    }

    private static KeyTransRecipientInfo buildKeyTransRecipientInfo(RecipientIdentifier recipientIdentifier, AlgorithmIdentifier encryptAlgOid, ASN1OctetString encryptedKeyValue) {
        return new KeyTransRecipientInfo(recipientIdentifier, encryptAlgOid, encryptedKeyValue);
    }

    private static RecipientInfo buildRecipientInfo(KeyTransRecipientInfo keyTransRecipientInfo) {
        return new RecipientInfo(keyTransRecipientInfo);
    }

    private static ContentInfo getContentInfo(byte[] data) throws SOR_DecryptDataException {
        try {
            ContentInfo contentInfo = ContentInfo.getInstance(data);
            if (contentInfo == null) {
                throw new SOR_DecryptDataException("getContentInfo error");
            }
            return contentInfo;
        }
        catch (Exception e) {
            throw new SOR_DecryptDataException("getContentInfo error");
        }
    }

    private static boolean isSm2ContentInfo(ContentInfo contentInfo) {
        ASN1ObjectIdentifier contentType = contentInfo.getContentType();
        return GMOid.envelopedData.getId().equals(contentType.getId());
    }

    private static boolean isRsaContentInfo(ContentInfo contentInfo) {
        ASN1ObjectIdentifier contentType = contentInfo.getContentType();
        return PKCSObjectIdentifiers.envelopedData.getId().equals(contentType.getId());
    }

    public static byte[] getDataCipher(byte[] data) throws Exception {
        ContentInfo contentInfo = ContentInfoUtils.getContentInfo(data);
        if (ContentInfoUtils.isSm2ContentInfo(contentInfo)) {
            Sm2EnvelopedData sm2EnvelopedData = Sm2EnvelopedData.getInstance(contentInfo.getContent());
            Sm2EncryptedContentInfo encryptedContentInfo = sm2EnvelopedData.getEncryptedContentInfo();
            return encryptedContentInfo.getEncryptedContent().getOctets();
        }
        if (ContentInfoUtils.isRsaContentInfo(contentInfo)) {
            EnvelopedData rsaEnvelopedData = EnvelopedData.getInstance(contentInfo.getContent());
            EncryptedContentInfo encryptedContentInfo = rsaEnvelopedData.getEncryptedContentInfo();
            return encryptedContentInfo.getEncryptedContent().getOctets();
        }
        throw new SOR_DecryptDataException("getContentInfo unmatched oid");
    }

    public static byte[] getSymmKey(byte[] data) throws Exception {
        ContentInfo contentInfo = ContentInfoUtils.getContentInfo(data);
        if (ContentInfoUtils.isSm2ContentInfo(contentInfo)) {
            Sm2EnvelopedData sm2EnvelopedData = Sm2EnvelopedData.getInstance(contentInfo.getContent());
            Sm2RecipientInfo recipientInfo = Sm2RecipientInfo.getInstance(sm2EnvelopedData.getRecipientInfos().getObjectAt(0));
            return recipientInfo.getEncryptedKey().getOctets();
        }
        if (ContentInfoUtils.isRsaContentInfo(contentInfo)) {
            EnvelopedData rsaEnvelopedData = EnvelopedData.getInstance(contentInfo.getContent());
            KeyTransRecipientInfo recipientInfo = KeyTransRecipientInfo.getInstance(rsaEnvelopedData.getRecipientInfos().getObjectAt(0));
            return recipientInfo.getEncryptedKey().getOctets();
        }
        throw new SOR_DecryptDataException("getContentInfo unmatched oid");
    }

    public static byte[] getIv(byte[] data) throws Exception {
        ContentInfo contentInfo = ContentInfoUtils.getContentInfo(data);
        if (ContentInfoUtils.isSm2ContentInfo(contentInfo)) {
            Sm2EnvelopedData sm2EnvelopedData = Sm2EnvelopedData.getInstance(contentInfo.getContent());
            Sm2EncryptedContentInfo encryptedContentInfo = sm2EnvelopedData.getEncryptedContentInfo();
            AlgorithmIdentifier ivAlg = encryptedContentInfo.getContentEncryption();
            ASN1OctetString ivData = DEROctetString.getInstance(ivAlg.getParameters());
            if (ivData == null) {
                return "".getBytes();
            }
            return ivData.getOctets();
        }
        if (ContentInfoUtils.isRsaContentInfo(contentInfo)) {
            EnvelopedData rsaEnvelopedData = EnvelopedData.getInstance(contentInfo.getContent());
            EncryptedContentInfo encryptedContentInfo = rsaEnvelopedData.getEncryptedContentInfo();
            AlgorithmIdentifier ivAlg = encryptedContentInfo.getContentEncryptionAlgorithm();
            ASN1OctetString ivData = DEROctetString.getInstance(ivAlg.getParameters());
            if (ivData == null) {
                return "".getBytes();
            }
            return ivData.getOctets();
        }
        throw new SOR_DecryptDataException("getContentInfo unmatched oid");
    }

    public static X509Certificate parseCert(byte[] signedMessage) throws Exception {
        ContentInfo contentInfo = ContentInfo.getInstance(signedMessage);
        if (contentInfo == null) {
            throw new SOR_Pkcs7EncodeException("message convert to contentInfo error");
        }
        if (contentInfo.getContentType().getId().equals(GMOid.signedData.getId())) {
            ASN1Encodable realSignMsg = contentInfo.getContent();
            Sm2SignedData gmt0010SignedData = Sm2SignedData.getInstance(realSignMsg);
            return CertUtils.convert2Certificate(gmt0010SignedData.getCertificates().getObjectAt(0).toASN1Primitive().getEncoded());
        }
        ASN1Encodable realSignMsg = contentInfo.getContent();
        SignedData signedData = SignedData.getInstance(realSignMsg);
        return CertUtils.convert2Certificate(signedData.getCertificates().getObjectAt(0).toASN1Primitive().getEncoded());
    }
}

