/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.gmt;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEROctetString;

public class Sm2ContentInfo
extends ASN1Object {
    private ASN1ObjectIdentifier contentType;
    private ASN1OctetString content;

    public static Sm2ContentInfo getInstance(Object var0) {
        if (var0 instanceof Sm2ContentInfo) {
            return (Sm2ContentInfo)var0;
        }
        return var0 != null ? new Sm2ContentInfo(ASN1Sequence.getInstance(var0)) : null;
    }

    public static Sm2ContentInfo getInstance(ASN1TaggedObject var0, boolean var1) {
        return Sm2ContentInfo.getInstance(ASN1Sequence.getInstance(var0, var1));
    }

    public Sm2ContentInfo(ASN1Sequence var1) {
        if (var1.size() >= 1 && var1.size() <= 2) {
            ASN1Encodable contentType = var1.getObjectAt(0);
            this.contentType = ASN1ObjectIdentifier.getInstance(contentType.toASN1Primitive());
            if (var1.size() > 1) {
                ASN1TaggedObject var2 = (ASN1TaggedObject)var1.getObjectAt(1);
                if (!var2.isExplicit() || var2.getTagNo() != 0) {
                    throw new IllegalArgumentException("Bad tag for 'content'");
                }
                this.content = DEROctetString.getInstance(var2.getObject());
            }
        } else {
            throw new IllegalArgumentException("Bad sequence size: " + var1.size());
        }
    }

    public ASN1OctetString getContent() {
        return this.content;
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.contentType;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector var1 = new ASN1EncodableVector();
        var1.add(this.contentType);
        if (this.content != null) {
            var1.add(new BERTaggedObject(0, this.content));
        }
        return new BERSequence(var1);
    }
}

