/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.gmt;

import java.nio.charset.StandardCharsets;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class Sm2EncryptedContentInfo
extends ASN1Object {
    private AlgorithmIdentifier contentType;
    private AlgorithmIdentifier contentEncryption;
    private ASN1OctetString encryptedContent;
    private ASN1OctetString shareInfo1;
    private ASN1OctetString shareInfo2;

    public Sm2EncryptedContentInfo(AlgorithmIdentifier contentType, AlgorithmIdentifier symmencMethod, byte[] encryptedContent, String shareInfo1, String shareInfo2) {
        this.contentType = contentType;
        this.contentEncryption = symmencMethod;
        this.encryptedContent = new DEROctetString(encryptedContent);
        this.shareInfo1 = new DEROctetString(shareInfo1.getBytes(StandardCharsets.UTF_8));
        this.shareInfo2 = new DEROctetString(shareInfo2.getBytes(StandardCharsets.UTF_8));
    }

    public Sm2EncryptedContentInfo(ASN1Sequence instance) throws Exception {
        ASN1InputStream asn1InputStream = new ASN1InputStream(instance.toASN1Primitive().getEncoded());
        ASN1Primitive asn1Primitive = asn1InputStream.readObject();
        if (asn1Primitive == null) {
            return;
        }
        ASN1Sequence asn1Sequence = (ASN1Sequence)asn1Primitive;
        this.contentType = AlgorithmIdentifier.getInstance(asn1Sequence.getObjectAt(0));
        this.contentEncryption = AlgorithmIdentifier.getInstance(asn1Sequence.getObjectAt(1));
        this.encryptedContent = DEROctetString.getInstance(DERTaggedObject.getInstance(asn1Sequence.getObjectAt(2)).getObject());
    }

    public static Sm2EncryptedContentInfo getInstance(Object var0) throws Exception {
        if (var0 instanceof Sm2EncryptedContentInfo) {
            return (Sm2EncryptedContentInfo)var0;
        }
        return var0 != null ? new Sm2EncryptedContentInfo(ASN1Sequence.getInstance(var0)) : null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.contentType);
        vector.add(this.contentEncryption);
        vector.add(new DERTaggedObject(false, 0, this.encryptedContent));
        vector.add(new DERTaggedObject(false, 1, this.shareInfo1));
        vector.add(new DERTaggedObject(false, 2, this.shareInfo2));
        return new DERSequence(vector);
    }

    public ASN1OctetString getEncryptedContent() {
        return this.encryptedContent;
    }

    public AlgorithmIdentifier getContentEncryption() {
        return this.contentEncryption;
    }
}

