/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.gmt;

import com.xdja.svs.common.Log;
import com.xdja.svs.gmt.Sm2EncryptedContentInfo;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;

public class Sm2EnvelopedData
extends ASN1Object {
    private ASN1Integer version;
    private ASN1Set recipientInfos;
    private Sm2EncryptedContentInfo encryptedContentInfo;

    public Sm2EnvelopedData(ASN1Set recipientInfos, Sm2EncryptedContentInfo encryptedContentInfo) {
        this.version = new ASN1Integer(1L);
        this.recipientInfos = recipientInfos;
        this.encryptedContentInfo = encryptedContentInfo;
    }

    public Sm2EnvelopedData(ASN1Sequence var1) throws Exception {
        this.version = (ASN1Integer)var1.getObjectAt(0);
        ASN1Encodable var2 = var1.getObjectAt(1);
        if (var2 instanceof ASN1TaggedObject) {
            var2 = var1.getObjectAt(1);
        }
        this.recipientInfos = ASN1Set.getInstance(var2);
        this.encryptedContentInfo = Sm2EncryptedContentInfo.getInstance(var1.getObjectAt(2));
    }

    public static Sm2EnvelopedData getInstance(ASN1TaggedObject var0, boolean var1) throws Exception {
        return Sm2EnvelopedData.getInstance(ASN1Sequence.getInstance(var0, var1));
    }

    public static Sm2EnvelopedData getInstance(Object var0) throws Exception {
        if (var0 instanceof Sm2EnvelopedData) {
            return (Sm2EnvelopedData)var0;
        }
        if (var0 == null) {
            return null;
        }
        ASN1Sequence sequence = null;
        try {
            sequence = ASN1Sequence.getInstance(var0);
            return new Sm2EnvelopedData(sequence);
        }
        catch (Exception e) {
            Log.print(e.getMessage());
            return null;
        }
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public void setVersion(ASN1Integer version) {
        this.version = version;
    }

    public ASN1Set getRecipientInfos() {
        return this.recipientInfos;
    }

    public Sm2EncryptedContentInfo getEncryptedContentInfo() {
        return this.encryptedContentInfo;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector var1 = new ASN1EncodableVector();
        var1.add(this.version);
        var1.add(this.recipientInfos);
        var1.add(this.encryptedContentInfo);
        return new DERSequence(var1);
    }
}

