/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.gmt;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class Sm2RecipientInfo
extends ASN1Object {
    private ASN1Integer version;
    private IssuerAndSerialNumber issuerAndSerialNumber;
    private AlgorithmIdentifier keyEncryptionAlgorithm;
    private ASN1OctetString encryptedKey;

    public Sm2RecipientInfo(IssuerAndSerialNumber issuerAndSerialNumber, AlgorithmIdentifier keyEncryptionAlgorithm, byte[] encryptedKey) {
        this.version = new ASN1Integer(1L);
        this.issuerAndSerialNumber = issuerAndSerialNumber;
        this.keyEncryptionAlgorithm = keyEncryptionAlgorithm;
        this.encryptedKey = new DEROctetString(encryptedKey);
    }

    public Sm2RecipientInfo(ASN1Sequence var1) {
        this.version = (ASN1Integer)var1.getObjectAt(0);
        this.issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(var1.getObjectAt(1));
        this.keyEncryptionAlgorithm = AlgorithmIdentifier.getInstance(var1.getObjectAt(2));
        this.encryptedKey = (ASN1OctetString)var1.getObjectAt(3);
    }

    public static Sm2RecipientInfo getInstance(Object var0) {
        if (var0 instanceof Sm2RecipientInfo) {
            return (Sm2RecipientInfo)var0;
        }
        return var0 != null ? new Sm2RecipientInfo(ASN1Sequence.getInstance(var0)) : null;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public IssuerAndSerialNumber getRecipientIdentifier() {
        return this.issuerAndSerialNumber;
    }

    public AlgorithmIdentifier getKeyEncryptionAlgorithm() {
        return this.keyEncryptionAlgorithm;
    }

    public ASN1OctetString getEncryptedKey() {
        return this.encryptedKey;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector var1 = new ASN1EncodableVector();
        var1.add(this.version);
        var1.add(this.issuerAndSerialNumber);
        var1.add(this.keyEncryptionAlgorithm);
        var1.add(this.encryptedKey);
        return new DERSequence(var1);
    }
}

