/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.gmt;

import com.xdja.svs.gmt.Sm2ContentInfo;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cms.SignedData;

public class Sm2SignedData
extends ASN1Object {
    private ASN1Integer version = new ASN1Integer(1L);
    private ASN1Set digestAlgorithms;
    private Sm2ContentInfo gmt0010ContentInfo;
    private ASN1Set certificates;
    private ASN1Set crls;
    private ASN1Set signedInfos;

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.version);
        vector.add(this.digestAlgorithms);
        vector.add(this.gmt0010ContentInfo);
        vector.add(this.certificates);
        vector.add(this.crls);
        vector.add(this.signedInfos);
        return new DERSequence(vector);
    }

    public static Sm2SignedData getInstance(Object var0) {
        if (var0 instanceof SignedData) {
            return (Sm2SignedData)var0;
        }
        return var0 != null ? new Sm2SignedData(ASN1Sequence.getInstance(var0)) : null;
    }

    private Sm2SignedData(ASN1Sequence sequence) {
        Enumeration var2 = sequence.getObjects();
        this.version = ASN1Integer.getInstance(var2.nextElement());
        this.digestAlgorithms = (ASN1Set)var2.nextElement();
        this.gmt0010ContentInfo = Sm2ContentInfo.getInstance(var2.nextElement());
        while (var2.hasMoreElements()) {
            ASN1Primitive var3 = (ASN1Primitive)var2.nextElement();
            if (var3 instanceof ASN1TaggedObject) {
                ASN1TaggedObject var4 = (ASN1TaggedObject)var3;
                switch (var4.getTagNo()) {
                    case 0: {
                        this.certificates = ASN1Set.getInstance(var4, false);
                        break;
                    }
                    case 1: {
                        this.crls = ASN1Set.getInstance(var4, false);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown tag value " + var4.getTagNo());
                    }
                }
                continue;
            }
            this.signedInfos = (ASN1Set)var3;
        }
    }

    private ASN1Primitive toASN1Object(X509Certificate cert) throws CertificateEncodingException {
        try {
            return new ASN1InputStream(cert.getEncoded()).readObject();
        }
        catch (Exception e) {
            throw new CertificateEncodingException("Exception while encoding certificate: " + e.toString());
        }
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public void setVersion(ASN1Integer version) {
        this.version = version;
    }

    public Sm2ContentInfo getGmt0010ContentInfo() {
        return this.gmt0010ContentInfo;
    }

    public ASN1Set getCertificates() {
        return this.certificates;
    }

    public ASN1Set getSignedInfos() {
        return this.signedInfos;
    }
}

