/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.protocol;

import com.xdja.svs.protocol.IRequest;
import java.util.Date;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class SvsRequest
extends ASN1Object {
    private ASN1Integer version = new ASN1Integer(0L);
    private ASN1Integer reqType;
    private ASN1Object request;
    private ASN1GeneralizedTime generalizedTime;

    public SvsRequest(IRequest request) {
        this.reqType = new ASN1Integer(request.apiCode().value());
        this.request = request.getRequestBody();
        this.generalizedTime = new ASN1GeneralizedTime(new Date());
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.version);
        vector.add(this.reqType);
        vector.add(new DERTaggedObject(false, this.reqType.getValue().intValue(), this.request.toASN1Primitive()));
        vector.add(this.generalizedTime);
        DERSequence derSequence = new DERSequence(vector);
        return derSequence;
    }

    public ASN1Object getRequest() {
        return this.request;
    }

    public void setRequest(ASN1Object request) {
        this.request = request;
    }
}

