/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.protocol;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;

public class SvsResponse
extends ASN1Object {
    private ASN1Integer version;
    private ASN1Integer respType;
    private ASN1Object responseBody;
    private ASN1GeneralizedTime generalizedTime;

    public SvsResponse(ASN1Sequence instance) {
        this.version = ASN1Integer.getInstance(instance.getObjectAt(0));
        this.respType = ASN1Integer.getInstance(instance.getObjectAt(1));
        this.responseBody = (ASN1Object)instance.getObjectAt(2);
        this.generalizedTime = ASN1GeneralizedTime.getInstance(instance.getObjectAt(3));
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.version);
        vector.add(this.respType);
        vector.add(this.responseBody);
        vector.add(this.generalizedTime);
        return new DERSequence(vector);
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public ASN1Integer getRespType() {
        return this.respType;
    }

    public ASN1Object getResponseBody() {
        return this.responseBody;
    }

    public ASN1GeneralizedTime getGeneralizedTime() {
        return this.generalizedTime;
    }
}

