/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.protocol.application;

import com.xdja.svs.common.ApiMethodId;
import com.xdja.svs.protocol.IRequest;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class SessionApiRequest
extends ASN1Object
implements IRequest {
    private ASN1OctetString appName;

    public SessionApiRequest(String appName) {
        this.appName = new DEROctetString(appName.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.appName);
        return new DERSequence(vector);
    }

    public ASN1OctetString getAppName() {
        return this.appName;
    }

    public void setAppName(ASN1OctetString appName) {
        this.appName = appName;
    }

    @Override
    public ASN1Object getRequestBody() {
        return this;
    }

    @Override
    public ApiMethodId apiCode() {
        return ApiMethodId.RELATE_APP_REQ;
    }
}

