/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.protocol.application;

import com.xdja.svs.protocol.IResponse;
import com.xdja.svs.protocol.response.AppContext;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class SessionApiResponse
extends ASN1Object
implements IResponse {
    private ASN1Integer respValue;
    private AppContext appContext;

    public SessionApiResponse(ASN1Encodable asn1Encodable) throws Exception {
        DERTaggedObject dlTaggedObject = (DERTaggedObject)asn1Encodable.toASN1Primitive();
        if (dlTaggedObject.getObject() instanceof ASN1Integer) {
            this.respValue = ASN1Integer.getInstance(dlTaggedObject.getObjectParser(0, true));
        } else {
            ASN1Sequence asn1Sequence = (ASN1Sequence)dlTaggedObject.getObject();
            this.respValue = ASN1Integer.getInstance(asn1Sequence.getObjectAt(0));
            this.appContext = new AppContext((ASN1Sequence)asn1Sequence.getObjectAt(1));
        }
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.respValue);
        try {
            vector.add(ASN1Primitive.fromByteArray(this.appContext.getEncoded()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new DERSequence(vector);
    }

    public int getRespValue() {
        return this.respValue.getValue().intValue();
    }

    public AppContext getAppContext() {
        return this.appContext;
    }

    public boolean isSuccess() {
        return this.respValue.getValue().intValue() == 0;
    }

    public ASN1Object parse(ASN1Sequence response) throws Exception {
        return new SessionApiResponse(response);
    }
}

