/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.protocol.certinfo;

import com.xdja.svs.common.ApiMethodId;
import com.xdja.svs.common.Log;
import com.xdja.svs.execption.SOR_CertEncodeException;
import com.xdja.svs.protocol.IRequest;
import com.xdja.svs.utils.CertUtils;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERSequence;

public class ParseCertRequest
extends ASN1Object
implements IRequest {
    private ASN1Integer infoType;
    private X509Certificate cert;

    public ParseCertRequest(Integer infoType, byte[] cert) throws SOR_CertEncodeException {
        this.infoType = new ASN1Integer(infoType.intValue());
        this.cert = CertUtils.convert2Certificate(cert);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.infoType);
        try {
            vector.add(ASN1Primitive.fromByteArray(this.cert.getEncoded()));
        }
        catch (Exception e) {
            Log.print(e.getMessage());
        }
        return new DERSequence(vector);
    }

    @Override
    public ASN1Object getRequestBody() {
        return this;
    }

    @Override
    public ApiMethodId apiCode() {
        return ApiMethodId.PARSE_CERT;
    }
}

