/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.protocol.certinfo;

import com.xdja.svs.common.ApiMethodId;
import com.xdja.svs.protocol.IRequest;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERSequence;

public class ValidateCertRequest
extends ASN1Object
implements IRequest {
    private X509Certificate cert;
    private ASN1Boolean ocsp;

    public ValidateCertRequest(X509Certificate cert, boolean ocsp) {
        this.cert = cert;
        this.ocsp = ASN1Boolean.getInstance(ocsp);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        try {
            vector.add(ASN1Primitive.fromByteArray(this.cert.getEncoded()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        vector.add(this.ocsp);
        return new DERSequence(vector);
    }

    @Override
    public ASN1Object getRequestBody() {
        return this;
    }

    @Override
    public ApiMethodId apiCode() {
        return ApiMethodId.VALIDATE_CERT;
    }
}

