/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.protocol.certinfo;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class ValidateCertResponse
extends ASN1Object {
    private ASN1Integer respValue;
    private ASN1Integer state;

    public ValidateCertResponse(ASN1Encodable instance) throws Exception {
        DERTaggedObject derTaggedObject = (DERTaggedObject)instance.toASN1Primitive();
        if (derTaggedObject.getObject() instanceof ASN1Integer) {
            this.respValue = ASN1Integer.getInstance(derTaggedObject.getObjectParser(0, true));
        } else {
            ASN1Sequence asn1Sequence = (ASN1Sequence)derTaggedObject.getObject();
            this.respValue = ASN1Integer.getInstance(asn1Sequence.getObjectAt(0));
            this.state = ASN1Integer.getInstance(asn1Sequence.getObjectAt(1));
        }
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.respValue);
        vector.add(this.state);
        return new DERSequence(vector);
    }

    public int getStateCode() {
        return this.state.getValue().intValue();
    }

    public int getResValue() {
        return this.respValue.getValue().intValue();
    }

    public boolean isSuccess() {
        return this.respValue.getValue().intValue() == 0;
    }
}

