/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.protocol.encryptdata.request;

import com.xdja.svs.Session;
import com.xdja.svs.alg.EncAlg;
import com.xdja.svs.common.ApiMethodId;
import com.xdja.svs.protocol.IRequest;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class MultiDecryptDataInitRequest
extends ASN1Object
implements IRequest {
    private ASN1Integer keyIndex;
    private ASN1OctetString keyValue;
    private ASN1OctetString encKey;
    private ASN1Integer encAlg;
    private ASN1OctetString iv;
    private ASN1Integer paddingType;

    public MultiDecryptDataInitRequest(Session session, byte[] encKey, byte[] iv) {
        this.keyIndex = new ASN1Integer(session.getPrivateKeyIndex());
        this.keyValue = new DEROctetString(session.getPrivateKeyPwd().getBytes(StandardCharsets.UTF_8));
        this.encKey = new DEROctetString(encKey);
        this.encAlg = new ASN1Integer(session.getEncAlg());
        this.paddingType = new ASN1Integer(0L);
        if (EncAlg.wrapIv(session.getEncAlg())) {
            this.iv = new DEROctetString(iv);
        }
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.keyIndex);
        vector.add(this.keyValue);
        vector.add(this.encKey);
        vector.add(this.encAlg);
        vector.add(this.paddingType);
        if (this.iv != null) {
            vector.add(this.iv);
        }
        return new DERSequence(vector);
    }

    @Override
    public ASN1Object getRequestBody() {
        return this;
    }

    @Override
    public ApiMethodId apiCode() {
        return ApiMethodId.DECRYPT_DATA_REQ_INIT;
    }
}

