/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.svs.protocol.encryptdata.request;

import com.xdja.svs.Session;
import com.xdja.svs.alg.EncAlg;
import com.xdja.svs.common.ApiMethodId;
import com.xdja.svs.protocol.IRequest;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class MultiDecryptDataUpdateRequest
extends ASN1Object
implements IRequest {
    private ASN1Integer keyID;
    private ASN1OctetString cipherText;
    private ASN1OctetString iv;

    public MultiDecryptDataUpdateRequest(Session session, long keyID, byte[] cipherText, byte[] iv) {
        this.keyID = new ASN1Integer(keyID);
        this.cipherText = new DEROctetString(cipherText);
        if (EncAlg.wrapIv(session.getEncAlg())) {
            this.iv = new DEROctetString(iv);
        }
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.keyID);
        vector.add(this.cipherText);
        if (this.iv != null) {
            vector.add(this.iv);
        }
        return new DERSequence(vector);
    }

    @Override
    public ASN1Object getRequestBody() {
        return this;
    }

    @Override
    public ApiMethodId apiCode() {
        return ApiMethodId.DECRYPT_DATA_REQ_UPDATE;
    }
}

